/* **************************************************************************

 * $Novell: RemoveOrphanPartition.java,v 1.6 2003/08/21 11:53:55 $

 *

 * Copyright (C) 2001 Novell, Inc. All Rights Reserved.

 * 

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE. 

 ***************************************************************************/

import com.novell.ldap.LDAPConnection;

import com.novell.ldap.LDAPException;

import com.novell.ldap.LDAPExtendedOperation;

import com.novell.ldap.LDAPExtendedResponse;

import com.novell.ldap.extensions.RemoveOrphanPartitionRequest;

import java.io.UnsupportedEncodingException;



/**

 *  The following sample demonstrates how to delete an orphan

 *  partition using Novell LDAP extensions.

 *

 */

public class RemoveOrphanPartition {



    public static void main( String[] args ) {



        if (args.length != 6) {

            System.err.println("Usage:   java RemoveOrphanPartition"

                    + " <host Name> <port number> <login dn> <password>"

                    + "\n         <partition dn> <server ND>");

            System.err.println("Example: java RemoveOrphanPartition"

                    + " Acme.com 389 \"cn=Admin,o=Acme\" secret\n         "

                    + "\"ou=Sales,o=Acme\" \"cn=myServer,o=Acme\"");

            System.exit(1);

        }



        int    ldapVersion = LDAPConnection.LDAP_V3;

        String ldapHost    = args[0];

        int    ldapPort    = Integer.parseInt(args[1]);

        String loginDN     = args[2];

        String password    = args[3];

        String partitionDN = args[4];

        String serverDN    = args[6];

        LDAPConnection ld  = new LDAPConnection();



        try {

            // connect to the server

            ld.connect( ldapHost, ldapPort);

            // bind to the server

            ld.bind( ldapVersion, loginDN, password.getBytes("UTF8") );

            System.out.println( "\nLogin succeeded");



            LDAPExtendedOperation request = 

                new RemoveOrphanPartitionRequest(serverDN, partitionDN);



            LDAPExtendedResponse response = ld.extendedOperation(request);



            if ( response.getResultCode() == LDAPException.SUCCESS )

                System.out.println("Deleted orphan partition.\n");

            else {                

                System.out.println("Could not delete orphan partition.");

                throw new LDAPException( response.getErrorMessage(),

                                         response.getResultCode(),

                                         (String)null);

            }



            /* Done, so disconnect */

            if ( ld.isConnected() )

                ld.disconnect();

        }

        catch( LDAPException e ) {

            System.out.println( "\nError: " + e.toString() );

        }

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }

    }

}

