/* **************************************************************************

 * $Novell: SetReplicationFilter.java,v 1.10 2003/08/21 11:54:40 $

 *

 * Copyright (C) 1999, 2000, 2001 Novell, Inc. All Rights Reserved.

 * 

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE. 

 ***************************************************************************/

import com.novell.ldap.LDAPConnection;

import com.novell.ldap.LDAPException;

import com.novell.ldap.LDAPExtendedOperation;

import com.novell.ldap.LDAPExtendedResponse;

import com.novell.ldap.extensions.SetReplicationFilterRequest;

import java.io.UnsupportedEncodingException;



/**

 *  The following sample demonstrates how to set the replication 

 *  filter on a LDAP server using LDAP extensions.

 *

 */

public class SetReplicationFilter {

    

    public static void main( String[] args ) {

        

        if (args.length != 5) {

            System.err.println("Usage:   java SetReplicationFilter <host Name>"

                              + " <port number> <login dn> <password>" 

                              + "\n         <server ND>");

            System.err.println("Example: java SetReplicationFilter Acme.com 389"

                              + " \"cn=Admin,o=Acme\" secret" 

                              + "\n         \"cn=myServer,o=Acme\"");

            System.exit(1);

        }



        int    ldapVersion = LDAPConnection.LDAP_V3;

        String ldapHost    = args[0];

        int    ldapPort    = Integer.parseInt(args[1]);

        String loginDN     = args[2];

        String password    = args[3];

        String serverDN    = args[4];

        LDAPConnection ld  = new LDAPConnection();

        

        try {

            // connect to the server

            ld.connect( ldapHost, ldapPort);

            // bind to the server

            ld.bind( ldapVersion, loginDN, password.getBytes("UTF8") );

            System.out.println( "\nLogin succeeded");



            String replicationFilter[][] = { {"inetOrgPerson",

                                              "commonName",

                                              "surname",

                                              "givenName",

                                              "countryName"},

                                             {"groupOfUniqueNames",

                                              "member"} };



            /** Do this to reset the filter  

            String replicationFilter[][] = null; */



            LDAPExtendedOperation request =

                new SetReplicationFilterRequest(serverDN, replicationFilter);

                                    

            LDAPExtendedResponse response = ld.extendedOperation(request);



            if ( response.getResultCode() == LDAPException.SUCCESS )

                System.out.println("Set Replication Filter Request succeeded\n");

            else {                

                System.out.println("Set Replication Filter Request Failed\n");

                throw new LDAPException( response.getErrorMessage(),

                                         response.getResultCode(),

                                         (String)null);

            }



            /* Done, so disconnect */

            if ( ld.isConnected() )

                ld.disconnect();

        }

        catch( LDAPException e ) {

            System.out.println( "\nError: " + e.toString() );

        }

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }

    }

}

