/*******************************************************************************

 * $Novell: SSLConnection.java,v 1.24 2006/02/03 06:14:06 $

 * Copyright (C) 1999, 2000, 2001 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:           SSLConnection.java

 * $description:    The SSLConnection.java sample shows how to set up a secure

 *                  SSL connection

 *

 * It is necessary to have an SSL package in your class path to run this

 * program. You can use JSSE, a Security provider implemented by Sun.  

 * Documentation is available from the NDK to set up Java SSL on a client.

 *

 * This example shows dynamic (run-time) configuration for JSSE provider

 * and for identification of keystores of trusted Certificates.

 ******************************************************************************/

import com.novell.ldap.*;

import java.security.Security;

import java.io.UnsupportedEncodingException;



public class SSLConnection

{

    public static void main( String[] args )

    {

        if (args.length != 4) {

           System.err.println("Usage:   java SSLConnection <host>"

                            + " <login dn> <password> <path/keystore>");

           System.err.println("Example: java SSLConnection nldap.novell.com"

                            + " \"cn=user,o=novell\" password "

                            + "/keystorePath/ssl.keystore");

           System.exit(1);

        }



        int ldapPort = LDAPConnection.DEFAULT_SSL_PORT;

        int ldapVersion = LDAPConnection.LDAP_V3;

        String ldapHost = args[0];

        String loginDN = args[1];

        String password = args[2];

        String path = args[3];

        LDAPSocketFactory ssf;



        try {

            // Dynamically set JSSE as a security provider

            Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());



            // Dynamically set the property that JSSE uses to identify

            // the keystore that holds trusted root certificates

            System.setProperty("javax.net.ssl.trustStore", path);



            ssf = new LDAPJSSESecureSocketFactory();



            // Set the socket factory as the default for all future connections

            LDAPConnection.setSocketFactory(ssf);



            // Note: the socket factory can also be passed in as a parameter

            // to the constructor to set it for this connection only.

            LDAPConnection lc = new LDAPConnection();



            // connect to the server

            lc.connect( ldapHost, ldapPort );



            // authenticate to the server

            lc.bind( ldapVersion, loginDN, password.getBytes("UTF8") );



            // at this point you are connected with a secure connection

            System.out.println( "Successful SSL bind with server.");



            lc.disconnect();

        }

        catch( LDAPException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }

    }

    

}

