/* **************************************************************************
  $Archive: /njcl_sample/Authenticator/CreateTokens.java $
  $Revision: 2 $
  $Modtime: 7/21/99 1:07p $

 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/
import com.novell.java.security.Authenticator;
import com.novell.java.security.Identity;
import com.novell.java.security.IdentityScope;
import com.novell.java.security.KeyManagementException;
import com.novell.service.security.NdsIdentity;
import com.novell.service.security.NdsIdentityScope;
import com.novell.service.security.BinderyIdentity;
import com.novell.service.security.BinderyIdentityScope;

/**
 * Sample which demonstrates how to use <code>Authenticator.createTokens</code>.
 */
public class CreateTokens
{
   static public void main(String args[])
   {
		if(args.length < 3)
		{
			System.out.println("Usage:  CreateTokens [NDS]-or-[BINDERY] -login <domain admin-name> " +
							   "-create <domain user-name>");
			System.out.println("E.g.:   CreateTokens [NDS] -login MyTree AdminOrgContext AdminGroupContext Admin" +
							   " -create MyTree MyOrgContext MyGroupContext Me" );
			System.out.println("E.g.:   CreateTokens [BINDERY] -login MyServer Admin -create MyServer Me");
			System.exit(-1);
		}

		try
      {
			Identity loginIdentity = null;
			Identity userIdentity = null;
			
			if(args[0].equalsIgnoreCase(NdsIdentityScope.ADMINISTRATIVE_DOMAIN_NAME)) {
				loginIdentity = buildNdsIdentity(null,0,getOption(args, "-login"));
				userIdentity  = buildNdsIdentity(null,0,getOption(args, "-create"));
			}
			else if(args[0].equalsIgnoreCase(BinderyIdentityScope.ADMINISTRATIVE_DOMAIN_NAME)) {
				loginIdentity = buildBinderyIdentity(null,0,getOption(args, "-login"));
				userIdentity  = buildBinderyIdentity(null,0,getOption(args, "-create"));
			}
			else
			{
				System.out.println("You must specify either [NDS] or [BINDERY] as the first scope.");
				System.exit(-1);
			}
			
         Authenticator.login(loginIdentity);
         Authenticator.createTokens(loginIdentity, userIdentity);         
      }
      catch(java.lang.Throwable e)
      {
         if (e instanceof java.lang.ExceptionInInitializerError)
            ((java.lang.ExceptionInInitializerError)e).getException().printStackTrace();
         e.printStackTrace();
      }
		finally
		{
		   // Must exit (see bug 4072987 at
		   // http://developer.javasoft.com/developer/bugParade)
			System.exit(0);
		}
   }

   static String [] getOption(String [] args, String option)
   {
   		int begin = 0;
   		while ((begin < args.length) && (!args[begin].equalsIgnoreCase(option))) 
   			begin ++;
   		if (!args[begin].equalsIgnoreCase(option))
   			return new String[] {args[0]};	// Always tag the first argument [NDS]-or-[BINDERY]

   		int end = begin+1;
   		while ((end < args.length) && (!args[end].startsWith("-"))) 
   			end ++;

   		String [] params = new String [ end - begin ];
   		params[0] = args[0];
   		for (int i=1; i<params.length; i++) 
   			params[i] = args[begin + i];
   		return params;
   }
   
   /*
	 * Constructs an identity with it's appropriate identity scopes.
	 * See documentation for details.
	 */
   static Identity buildNdsIdentity(IdentityScope scope, int offset, String args[])
      throws KeyManagementException
   {
      if( args.length == 0)
         return new NdsIdentity("");

      if(!(offset < args.length-1))
         return new NdsIdentity(args[offset],scope);

      return buildNdsIdentity(new NdsIdentityScope(args[offset],scope), ++offset, args);
   }

   /*
	 * Constructs an identity with it's appropriate identity scopes.
	 * See documentation for details.
	 */
   static Identity buildBinderyIdentity(IdentityScope scope, int offset, String args[])
      throws KeyManagementException
   {
      if( args.length == 0)
         return new BinderyIdentity("");

      if(!(offset < args.length-1))
         return new BinderyIdentity(args[offset],scope);

      return buildBinderyIdentity(new BinderyIdentityScope(args[offset],scope), ++offset, args);
   }
}
