/* **************************************************************************
  $Archive: /njcl_sample/Authenticator/Login.java $
  $Revision: 2 $
  $Modtime: 11/18/99 3:56p $

 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/
import com.novell.java.security.Authenticator;
import com.novell.java.security.Identity;
import com.novell.java.security.IdentityScope;
import com.novell.java.security.KeyManagementException;
import com.novell.service.security.NdsIdentity;
import com.novell.service.security.NdsIdentityScope;
import com.novell.service.security.BinderyIdentity;
import com.novell.service.security.BinderyIdentityScope;

/**
 * Performs a login of the passed in Identity obejct to its
 * scope. The appropriate Identity object is constructed depending
 * upon whether the scope is an NdsIdentityScope or a BinderyIdentityScope,
 * after which the Authenticator.login(identity) method is called.
 */
public class Login
{
   static public void main(String args[])
   {
      if(args.length < 3)
      {
         System.out.println("Usage:  Login [NDS]-or-[BINDERY] domain name");
         System.out.println("E.g.:   Login [NDS] MyTree MyOrgContext MyGroupContext Me");
         System.out.println("E.g.:   Login [BINDERY] MyServer Me");
         System.exit(-1);
      }

      try
      {
         /**
          * Create an Identity object.
          */
         Identity identity = null;
         /**
          * Construct the Identity with either the NdsIdentityScope or
          * the BinderyIdentityScope.
          */
         if(args[0].equalsIgnoreCase(NdsIdentityScope.ADMINISTRATIVE_DOMAIN_NAME))
            identity = buildNdsIdentity(null,0,args);
         else if(args[0].equalsIgnoreCase(BinderyIdentityScope.ADMINISTRATIVE_DOMAIN_NAME))
            identity = buildBinderyIdentity(null,0,args);
         else
         {
            System.out.println("You must specify either [NDS] or [BINDERY] as the first scope.");
            System.exit(-1);
         }
         Authenticator.login(identity);
      }
      catch(java.lang.Throwable e)
      {
         if (e instanceof java.lang.ExceptionInInitializerError)
            ((java.lang.ExceptionInInitializerError)e).getException().printStackTrace();
         e.printStackTrace();
      }
      finally
      {
         // Must exit (see bug 4072987 at
         // http://developer.javasoft.com/developer/bugParade)
         System.exit(0);
      }
   }
   
   /**
    * Builds an Identity object with the NDS identity scope.
    */
   static Identity buildNdsIdentity(IdentityScope scope, int offset, String args[])
      throws KeyManagementException
   {
      if( args.length == 0)
         return new NdsIdentity("");

      if(!(offset < args.length-1))
         return new NdsIdentity(args[offset],scope);

      return buildNdsIdentity(new NdsIdentityScope(args[offset],scope), ++offset, args);
   }

   /**
    * Builds an Identity object with the Bindery identity scope.
    */
   static Identity buildBinderyIdentity(IdentityScope scope, int offset, String args[])
      throws KeyManagementException
   {
      if( args.length == 0)
         return new BinderyIdentity("");

      if(!(offset < args.length-1))
         return new BinderyIdentity(args[offset],scope);

      return buildBinderyIdentity(new BinderyIdentityScope(args[offset],scope), ++offset, args);
   }
}