/***************************************************************************
 %name: Bind.java
 %version: 
 %date_modified: 
 %dependencies: TextualStatic.java

 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import java.io.Serializable;
import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

import com.novell.utility.naming.Environment;

/**
 * Example of explicit bindings
 *
 * <p>This program demonstrates how to explicitly bind foreign objects to
 * the file system providers Contexts.
 * </p>
 * <p>It uses the class BindObject.java
 * to demonstrate binding functionality in the file system. This classes
 * is included in this source file.
 */

class Bind
{  
   /**
    * Bind
    *
    * <p>Binds a non-File System object into the Context
    * specified in the url with the given name.
    * </p>
    *
    * <p>This program requires two command-line parameters.  The first
    * specifies the name of a Context of your choice of which to bind a
    * Foreign object.  The second parameter is the name of the foreign object
    * to bind.
    * </p>
    *
    * @param   args[]
    * where    arg[0]   url (url to bind object to)
    *          arg[1]   name (name of the object being bound)
    */

    public static void main(String args[])
    {
      // see if user has given the URL and bind name on the command line
      if (args.length < 2)
      {
         help();
      }

      String target = args[0];
      String source = args[1];
      String name = args[2];

      // Set the initial context factory to NetWareInitialContextFactory
      Hashtable env = new Hashtable();
      env.put(
         Context.INITIAL_CONTEXT_FACTORY,
         Environment.FS_INITIAL_CONTEXT_FACTORY);
      try
      {
         // Look up the object named by the command line parameter.
         env.put(Context.PROVIDER_URL, target);
         Context targetContext =
            (Context) new InitialContext(env).lookup("");
            
         env.put(Context.PROVIDER_URL, source);
         Context sourceContext =
            (Context) new InitialContext(env).lookup("");

         System.out.println("\nBinding object " 
            + name 
            + " ( at url " 
            + source
            + ") \n"
            + " to " 
            + target + "\n");

         // bind in a BindObject with the given name
         targetContext.bind(name, sourceContext);

         // look up the newly bound object and list its type
         Object obj = targetContext.lookup(name);
         System.out.println("bound object's type: " + obj.getClass().getName());

      }
      catch (javax.naming.NamingException e)
      {
         System.out.println("\nException thrown: " + e);
         e.printStackTrace();
         System.exit(-1);
      }

      System.exit(0);
   }

   private static void help()
   {
      System.out.println(
         "\nTo use this example program enter the following:\n");
      System.out.println(
         "\tjava Bind <url> <name>\n");
      System.out.println(
         "\t\turl = name of the File System Context to bind an object to");
      System.out.println("\t\t       my_server/my_volume/bind_target");
      System.out.println(
         "\t\turl = name of the File System Context to be bound");
      System.out.println("\t\t       my_server/my_volume/bind_source");
      System.out.println(
         "\t\tname = name of the object that you want to bind");
      System.out.println("");
      System.exit(-1);
   }
}