/***************************************************************************
 %name: DirectoryDeleter.java
 %version: 
 %date_modified: 
 %dependencies: none

 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;

import com.novell.utility.naming.Environment;

/**
 * Deletes a given Directory.
 *
 * <p>This program demonstrates how to delete a directory that is subordinate
 * to an existing Directory DirContext which is specified on the command line.
 * The directory name being deleted must be empty.
 * </p>
 */

class DirectoryDeleter
{
   /**
    * DirectoryDeleter example
    *
    * <p>This example deletes a directory from a Directory
    * DirContext in the NetWare file system name space.  Directory being
    * deleted must be empty.
    * </p>
    *
    * @param args[0]
    * where    args[0]  parent (parent path)
    *                   The name of a Directory DirContext to be the
    *                   parent for the directory being deleted.
    *                   For example:
    *                   "my_server/my_volume/my_dir"
    *          args[1]  directory (directory name to delete)
    */

   public static void main(String args[])
   {
      // see if user has given the URL and directory on the command line
      if (args.length < 2)
      {
         help();
      }

      String parent = args[0];
      String directory = args[1];

      // Set the initial context factory to NetWareInitialContextFactory
      Hashtable systemProps = new Hashtable();
      systemProps.put(
         Context.INITIAL_CONTEXT_FACTORY,
         Environment.FS_INITIAL_CONTEXT_FACTORY);
      systemProps.put(Context.PROVIDER_URL, parent);
      try
      {
         // Get the initial context
         Context initialCtx = new InitialContext(systemProps);

         // Look up the object named by the command line parameter.
         Object obj = new InitialContext(systemProps).lookup("");

         System.out.println("\nDeleting " + directory + "\n");

         Context currCtx = (Context) obj;

         /* Delete the directory. */
         currCtx.destroySubcontext(directory);
      }
      catch(javax.naming.NamingException e)
      {
         System.out.println("\nException thrown: " + e);
         e.printStackTrace();
         System.exit(-1);
      }

      System.exit(0);
   }

   private static void help()
   {
      System.out.println(
         "\nTo use this example program enter the following:\n");
      System.out.println(
         "\tjava DirectoryDeletor <url> <directory>\n");
      System.out.println(
         "\t\turl = name of the directory to delete the directory from");
      System.out.println("\t\t       my_server/my_volume/my_dir");
      System.out.println(
         "\t\tdirectory  = directory name to delete");
      System.out.println("");
      System.exit(-1);
   }
}



