/***************************************************************************
 %name: GenericObjectList.java
 %version: 
 %date_modified: 
 %dependencies: TextualStatic.java
 
 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NameClassPair;

import com.novell.utility.naming.Environment;

/**
 * Generic code for listing names and objects bound to a JNDI Context
 *
 * <p>This program demonstrates generic code that can be used to display a
 * specified Contexts NameClassPair and Bindings that are subordinate to it.
 *
 *<p>Since this is generic code, this program prints the names of the
 * bindings, the types of the objects bound and the interfaces that those
 * bound objects implement.
 *
 * <p>In specific code, the bound objects can be cast to the actual
 * types or interface as needed.
 * </p>
 */

public class GenericObjectList
{
   /**
    * GenericObjectList example
    *
    * <p>This example lists the names of objects bound to a generic JNDI
    * DirContext.
    * </p>
    *
    * @param   args[]
    * where    args[0]  url (url to list)
    *                   The name of a Context from the NetWare
    *                   initial context.  For example:
    *                   "Servers/my_server/FileSystem/my_volume/my_dir"
    *                   "Trees/my_tree/my_tree_volume.my_context"
    */

   public static void main(String args[])
   {
      // see if user has given the URL on the command line
      if (args.length < 1)
      {
         help();
      }
      String url = args[0];
      // Set the initial context factory to NetWareInitialContextFactory
      Hashtable systemProps = new Hashtable();
      systemProps.put(
         Context.INITIAL_CONTEXT_FACTORY,
         Environment.NW_INITIAL_CONTEXT_FACTORY);

      try
      {
         // Get the initial context
         Context initialCtx = new InitialContext (systemProps);

         // Look up the object named by the command line parameter.
         System.out.println("Looking up: " + url);
         Object obj = initialCtx.lookup(url);

         // Cast the object to a Context
         Context currCtx = (Context) obj;

         // Get the NameClassPairs bound to this Context.
         NamingEnumeration ncEnum = currCtx.list("");

         // Get the bindings bound to this Context.
         NamingEnumeration bindingEnum = currCtx.listBindings("");

         while (ncEnum.hasMore())
         {
            NameClassPair ncPair = (NameClassPair)ncEnum.next();
            Binding binding = (Binding)bindingEnum.next();

            System.out.println(ncPair.getName());
            obj = binding.getObject();

            Class objClass = obj.getClass();
            do
            {
               // print the hierarchy of this objects type
               System.out.println(
                  "\tObject Type: " + objClass.getName());
               objClass = objClass.getSuperclass();
            }while(objClass != null);

            // list all the interfaces that this object implements
            Class[] interfaces = obj.getClass().getInterfaces();
            for (int i=0; i < interfaces.length; i++)
            {
               System.out.println(
                  "\timplements: " + interfaces[i].getName());
            }
         }
      }
      catch (javax.naming.NamingException e)
      {
         System.out.println("Exception thrown: " + e);
         e.printStackTrace();
         System.exit(-1);
      }
      System.exit(0);
   }

   private static void help()
   {
      System.out.println(
         "\nTo use this example program enter the following:\n");
      System.out.println(
         "\tjava GenericObjectList <url>\n");
      System.out.println(
         "\t\turl = name of the DirContext to list, for example:");
      System.out.println(
         "\t\t       Servers/my_server/FileSystem/my_volume/my_dir/... or");
      System.out.println(
      "\t\t       Trees/my_tree/my_tree_volume.my_context");
      System.out.println("");
      System.exit(-1);
   }

}

