/***************************************************************************
 %name: StaticAttributeValueInterface.java
 %version: 
 %date_modified: 
 %dependencies: none
 
 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import com.novell.service.file.nw.NetwareVolume;
import com.novell.service.file.nw.NetwareDirectory;
import com.novell.service.file.nw.NetwareFile;

import com.novell.service.file.nw.NetwareVolume;
import com.novell.service.file.nw.NetwareDirectory;
import com.novell.service.file.nw.NetwareFile;
import com.novell.service.file.nw.DirectoryEntryInformation;
import com.novell.service.file.nw.Trustee;
import com.novell.service.file.nw.TrusteeEnumerator;
import com.novell.service.file.nw.EAEnumerator;
import com.novell.service.file.nw.ExtendedAttribute;
import com.novell.service.file.nw.DirectorySpaceInformation;
import com.novell.service.file.nw.VolumeInformation;
import com.novell.service.file.nw.VolumeRestrictionEnumerator;
import com.novell.service.file.nw.VolumeRestriction;
import com.novell.service.file.nw.VolumeUtilization;

import com.novell.java.io.NFile;
import com.novell.java.io.RandomAccess;

import com.novell.service.jncp.NSIException;

import java.io.OutputStream;
import java.io.InputStream;
import java.io.IOException;

/** 
 * Declares methods for handling the various attribute values
 *
 * <p>This class provides common support for several of the file systems
 * example programs.  It is entended to provide and example of utilizing the
 * static attribute value interfaces.
 * </p>
 *
 * @see DirectoryAttrList
 * @see FileAttrList
 * @see VolumeAttrList
 * @see Schema
 */

public interface StaticAttributeValueInterface
{
   /**
    * Handles objects of type NFile.
    * 
    * <p>The NFile is the base most type of the Meta-data leg of a file. 
    * This method simply demonstrates a handler for these types of objects.  
    * There are no modifiable fields available in the NFile interface.
    *
    * @param file              The NFile object
    *
    * @see com.novell.java.io.NFile
    */
    
   public void handleNFile(NFile file);

   /**
    * Handles objects of type NetwareFile.
    * 
    * <p>The NetwareFile is the base most type of the Meta-data leg of the
    * NetWare specific file system components. This method simply 
    * demonstrates a handler for these types of objects.  
    *
    * @param file              The NetwareFile object
    *
    * @see com.novell.service.file.nw.NetwareFile
    */
    
   public void handleNetwareFile(NetwareFile file);

   /**
    * Handles objects of type NetwareDirectory.
    * 
    * <p>The NetwareDirectory interface extends the NetwareFile interface.
    * This method simply demonstrates a handler for these types of objects.  
    *
    * @param directory           The NetwareDirectory object
    *
    * @see com.novell.service.file.nw.NetwareDirectory
    */
    
   public void handleNetwareDirectory(NetwareDirectory directory);

   /**
    * Handles objects of type NetwareVolume.
    * 
    * <p>The NetwareVolume interface extends the NetwareDirectory interface.
    * This method simply demonstrates a handler for these types of objects.  
    *
    * @param volume              The NetwareVolume object.
    * @param objectName          The object name to use for VolumeUtilization.
    *
    * @see com.novell.service.file.nw.NetwareVolume
    */
    
   public void handleNetwareVolume(NetwareVolume volume, String objectName);

   /**
    * Handles the DirectoryEntryInformation attribute value
    * 
    * <p>The DirectoryEntryInformation attribute value can be obtained from 
    * the NetwareFile.getDirectoryEntryInformation factory method.  The 
    * NetwareFile.setDirectoryEntryInformation method is available for 
    * modifying the valid settable fields.
    *
    * <p>This attribute value is available for a NetwareVolume, 
    * NetwareDirectory or NetwareFile object.
    * </p>
    *
    * @param file              The NetwareFile object
    *
    * @see com.novell.service.file.nw.NetwareFile
    * @see com.novell.service.file.nw.DirectoryEntryInformation
    */
    
   public void handleDirectoryEntryInformation(NetwareFile file);

   /**
    * Handles the TrusteeEnumerator attribute value
    * 
    * <p>The TrusteeEnumerator attribute value can be obtained from 
    * the NetwareFile.getTrusteeEnumerator factory method.  The 
    * NetwareFile.setTrustee method is available for 
    * modifying the valid settable fields.
    *
    * <p>This attribute value is available for a NetwareVolume, 
    * NetwareDirectory or NetwareFile object.
    * </p>
    *
    * @param file              The NetwareFile object
    *
    * @see com.novell.service.file.nw.NetwareFile
    * @see com.novell.service.file.nw.TrusteeEnumerator
    */
    
   public void handleTrusteeEnumerator(NetwareFile file);

   /**
    * Handles the EAEnumerator attribute value
    * 
    * <p>The EAEnumerator attribute value can be obtained from 
    * the NetwareFile.getEAEnumerator factory method.  The 
    * NetwareFile.setExtendedAttribute method is available for 
    * modifying the valid settable fields.
    *
    * <p>This attribute value is available for a NetwareVolume, 
    * NetwareDirectory or NetwareFile object.
    * </p>
    *
    * @param file              The NetwareFile object
    *
    * @see com.novell.service.file.nw.NetwareFile
    * @see com.novell.service.file.nw.EAEnumerator
    */
    
   public void handleEAEnumerator(NetwareFile file);

   /**
    * Handles the DirectorySpaceInformation attribute value
    * 
    * <p>The DirectorySpaceInformation attribute value can be obtained from 
    * the NetwareDirectory.getDirectorySpaceInformation factory method.  The 
    * NetwareDirectory.setDirectorySpaceInformation method is available for 
    * modifying the valid settable fields.
    *
    * <p>This attribute value is available for a NetwareVolume or
    * a NetwareDirectory.
    * </p>
    *
    * @param directory              The NetwareDirectory object
    *
    * @see com.novell.service.file.nw.NetwareDirectory
    * @see com.novell.service.file.nw.DirectorySpaceInformation
    */
    
   public void handleDirectorySpaceInformation(NetwareDirectory directory);

   /**
    * Handles the VolumeInformation attribute value
    * 
    * <p>The VolumeInformation attribute value can be obtained from 
    * the NetwareVolume.getVolumeInformation factory method.  There are no
    * modifiable fields in this attribute value.
    *
    * <p>This attribute value is available for a NetwareVolume.
    * </p>
    *
    * @param volume              The NetwareVolume object
    *
    * @see com.novell.service.file.nw.NetwareVolume
    * @see com.novell.service.file.nw.VolumeInformation
    */
    
   public void handleVolumeInformation(NetwareVolume volume);

   /**
    * Handles the volumeRestrictionEnumerator attribute value
    * 
    * <p>The volumeRestrictionEnumerator attribute value can be obtained from 
    * the NetwareVolume.getvolumeRestrictionEnumerator factory method.  The 
    * NetwareVolume.setvolumeRestriction method is available for 
    * modifying the valid settable fields.
    *
    * <p>This attribute value is available for a NetwareVolume.
    * </p>
    *
    * @param volume              The NetwareVolume object
    *
    * @see com.novell.service.file.nw.NetwareVolume
    * @see com.novell.service.file.nw.volumeRestrictionEnumerator
    */
    
   public void handleVolumeRestrictionEnumerator(NetwareVolume volume);

   /**
    * Handles the VolumeUtilization attribute value
    * 
    * <p>The VolumeUtilization attribute value can be obtained from 
    * the NetwareVolume.getVolumeUtilization factory method.  There are no
    * modifiable fields in this attribute value.
    *
    * <p>Volume Utilization is unique in that you must set the object name
    * before you can access any of the other setter or getter methods.  This 
    * is because the utilization information is obtained for the user that 
    * you specify at this time.
    *
    * <p>The JNDI dynamic attribute interface does not allow for the passing
    * of any parameters into the getAttributes interface.  This attribute 
    * value is designed to support the JNDI interface, that is why this
    * is the way it is.
    *
    * <p>This attribute value is available for a NetwareVolume.
    * </p>
    *
    * @param volume              The NetwareVolume object
    * @param objectName          The object name to obtain data on
    *
    * @see com.novell.service.file.nw.NetwareVolume
    * @see com.novell.service.file.nw.VolumeUtilization
    */
    
   public void handleVolumeUtilization(
      NetwareVolume volume, 
      String objectName);

   /**
    * Display a message to the user.  Displaying the value might be 
    * surpressed via a verbose flag in the actual implementation
    * 
    * @param value               value to display to the user
    */
    
   public void message(String value);

   /**
    * Common method to write a known pattern to an output stream.
    * 
    * @param os                  The OutputStream to write the pattern to.
    *
    * @exception IOException if os.write fails.
    */
    
   public void writeStream(OutputStream os) throws IOException;

   /**
    * Common method to read and verify a known pattern from an input stream.
    * 
    * @param is                  The InputStream to read and verify the
    *                            pattern from.
    *
    * @exception IOException if is.read fails.
    * @exception RuntimeException if pattern does not match.
    */
    
   public void readStream(InputStream is)
      throws IOException, RuntimeException;

   /**
    * Common method to verify a known pattern by random access.
    * 
    * @param ra                  The RandomAccess to read and verify the
    *                            pattern from.
    *
    * @exception IOException if is.read fails.
    * @exception RuntimeException if pattern does not match.
    */
    
   public void readRandom(RandomAccess ra)
      throws IOException, RuntimeException;
}   
