/***************************************************************************
 %name: Textual.java
 %version: 
 %date_modified: 
 %dependencies: none
 
 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import javax.naming.NamingException;
import javax.naming.NamingEnumeration;

import javax.naming.directory.DirContext;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

import com.novell.service.file.nw.NetwareVolume;
import com.novell.service.file.nw.NetwareDirectory;
import com.novell.service.file.nw.NetwareFile;
import com.novell.service.file.nw.DirectoryEntryInformation;
import com.novell.service.file.nw.Trustee;
import com.novell.service.file.nw.ExtendedAttribute;
import com.novell.service.file.nw.DirectorySpaceInformation;
import com.novell.service.file.nw.VolumeInformation;
import com.novell.service.file.nw.VolumeRestriction;
import com.novell.service.file.nw.VolumeUtilization;

/** 
 * Declares methods that would handle the various attribute values.
 *
 * <p>This class does a textual display of the various attribute values.  The
 * TextualStatic and TextualDynamic classes will call the various methods
 * in this class to actually display the individual fields of the attribute
 * values.
 * </p>
 *
 * @see TextualStatic
 * @see TextualDynamic
 */

public class Textual
{
   private boolean verbose;

   /**
    * Constructor that allows for the verbose flag to be set.
    * 
    * @param verbose             be verbose if true.
    */
    
   public Textual(boolean verbose)
   {
      this.verbose = verbose;  
   }

   /**
    * Displays the contents of the DirectoryEntryInformation attribute value.
    * 
    * @param value               The DirectoryEntryInformation object to 
    *                            display.
    *
    * @see com.novell.service.file.nw.DirectoryEntryInformation
    */
    
   public void displayDirectoryEntryInformation(
      DirectoryEntryInformation value)
   {
      message("spaceAlloc: " + value.getSpaceAlloc());
      message("attributes: " + value.getAttributes());
      message("flags: " + value.getFlags());
      message("dataStreamSize: " + value.getDataStreamSize());
      message("totalStreamSize: " + value.getTotalStreamSize());
      message("numberOfStreams: " + value.getNumberOfStreams());
      message("creationTime: " + value.getCreationTime());
      message("creationDate: " + value.getCreationDate());
      message("creator: " + value.getCreator());
      message("modifyTime: " + value.getModifyTime());
      message("modifyDate: " + value.getModifyDate());
      message("modifier: " + value.getModifier());
      message("lastAccessDate: " + value.getLastAccessDate());
      message("archiveTime: " + value.getArchiveTime());
      message("archiveDate: " + value.getArchiveDate());
      message("archiver: " + value.getArchiver());
      message(
         "inheritedRightsMask: " + value.getInheritedRightsMask());
      message("dirEntNum: " + value.getDirEntNum());
      message("DosDirNum: " + value.getDosDirNum());
      message("volNumber: " + value.getVolNumber());
      message("EADataSize: " + value.getEADataSize());
      message("EAKeyCount: " + value.getEAKeyCount());
      message("EAKeySize: " + value.getEAKeySize());
      message("NSCreator: " + value.getNSCreator());
      message("nameLength: " + value.getNameLength());
      message("entryName: " + value.getEntryName());
   }

   /**
    * Displays the contents of the Trustee attribute value.
    * 
    * @param value               The Trustee object to display.
    *                            Trustee objects.
    *
    * @see com.novell.service.file.nw.Trustee
    */
    
   public void displayTrustee(Trustee value)
   {
      message("name: " + value.getName());
      message("objectRights: " + value.getRights());
   }

   /**
    * Displays the contents of the ExtendedAttribute attribute value.
    * 
    * @param value               The ExtendedAttribute object to display.
    *
    * @see com.novell.service.file.nw.EAEnumerator
    */
    
   public void displayExtendedAttribute(ExtendedAttribute value)
   {
      message("name: " + value.getName());
   }

   /**
    * Displays the contents of the DirectorySpaceInformation attribute value.
    * 
    * @param value               The DirectorySpaceInformation object to
    *                            display.
    *
    * @see com.novell.service.file.nw.DirectorySpaceInformation
    */
    
   public void displayDirectorySpaceInformation(
      DirectorySpaceInformation value)
   {
      message("totalBlocks: " + value.getTotalBlocks());
      message("availableBlocks: " + value.getAvailableBlocks());
      message("purgeableBlocks: " + value.getPurgeableBlocks());
      message(
         "notYetPurgeableBlocks: " + value.getNotYetPurgeableBlocks());
      message("totalDirEntries: " + value.getTotalDirEntries());
      message(
         "availableDirEntries: " + value.getAvailableDirEntries());
      message("reserved: " + value.getReserved());
      message("sectorsPerBlock: " + value.getSectorsPerBlock());
      message("volName: " + value.getVolName());
      message("maxAvailable: " + value.getMaxAvailable());
      message("currentUse: " + value.getCurrentUse());
   }

   /**
    * Displays the contents of the VolumeInformation attribute value.
    * 
    * @param value               The VolumeInformation object to display.
    *
    * @see com.novell.service.file.nw.VolumeInformation
    */
    
   public void displayVolumeInformation(VolumeInformation value)
   {
      message("volName: " + value.getVolName());
      message("totalBlocks: " + value.getTotalBlocks());
      message("sectorsPerBlock: " + value.getSectorsPerBlock());
      message("availableBlocks: " + value.getAvailableBlocks());
      message("totalDirEntries: " + value.getTotalDirEntries());
      message(
         "availableDirEntries: " + value.getAvailableDirEntries());
      message(
         "volIsRemovableFlag: " + value.getVolIsRemovableFlag());
      message("volType: " + value.getVolType());
      message("statusFlag: " + value.getStatusFlag());
      message("sectorSize: " + value.getSectorSize());
      message(
         "sectorsPerCluster: " + value.getSectorsPerCluster());
      message(
         "volSizeInClusters: " + value.getVolSizeInClusters());
      message("freeClusters: " + value.getFreeClusters());
      message(
         "subAllocFreeableClusters: " + value.getSubAllocFreeableClusters());
      message(
         "freeableLimboSectors: " + value.getFreeableLimboSectors());
      message(
         "nonfreeableLimboSectors: " + value.getNonfreeableLimboSectors());
      message(
         "availSubAllocSectors: " + value.getAvailSubAllocSectors());
      message(
         "nonuseableSubAllocSectors: " + 
         value.getNonuseableSubAllocSectors());
      message(
         "subAllocClusters: " + value.getSubAllocClusters());
      message(
         "numDataStreams: " + value.getNumDataStreams());
      message(
         "numLimboDataStreams: " + value.getNumLimboDataStreams());
      message(
         "oldestDelFileAgeInTicks: " + value.getOldestDelFileAgeInTicks());
      message(
         "numCompressedDataStreams: " + value.getNumCompressedDataStreams());
      message(
         "numCompressedLimboDataStreams: " + 
         value.getNumCompressedLimboDataStreams());
      message(
         "numNoncompressibleDataStreams: " + 
         value.getNumNoncompressibleDataStreams());
      message(
         "precompressedSectors: " + value.getPrecompressedSectors());
      message(
         "compressedSectors: " + value.getCompressedSectors());
      message(
         "numMigratedDataStreams: " + value.getNumMigratedDataStreams());
      message(
         "migratedSectors: " + value.getMigratedSectors());
      message(
         "clustersUsedByFAT: " + value.getClustersUsedByFAT());
      message(
         "clustersUsedByDirs: " + value.getClustersUsedByDirs());
      message(
         "clustersUsedByExtDirs: " + value.getClustersUsedByExtDirs());
      message("unusedDirEntries: " + value.getUnusedDirEntries());
      message(
         "totalExtDirExtants: " + value.getTotalExtDirExtants());
      message(
         "unusedExtDirExtants: " + value.getUnusedExtDirExtants());
      message("extAttrsDefined: " + value.getExtAttrsDefined());
      message(
         "extAttrExtantsUsed: " + value.getExtAttrExtantsUsed());
      message(
         "directoryServicesName: " + value.getDirectoryServicesName());
      message(
         "volLastModifiedDateAndTime: " + 
         value.getVolLastModifiedDateAndTime());
      message(
         "purgeableBlocks: " + value.getPurgeableBlocks());
      message(
         "notYetPurgeableBlocks: " + value.getNotYetPurgeableBlocks());
   }

   /**
    * Displays the contents of the VolumeRestriction attribute value.
    * 
    * @param value               VolumeRestriction object to display.
    *
    * @see com.novell.servaluece.file.nw.VolumeRestrictionEnumerator
    */
    
   public void displayVolumeRestriction(VolumeRestriction value)
   {
      message("name: " + value.getName());
      message("objectId: " + value.getObjectId());
      message("restriction: " + value.getRestriction());
      message("inUse: " + value.getInUse());
   }

   /**
    * Displays the contents of the VolumeUtilization attribute value.
    * 
    * @param value               The VolumeUtilization object to display.
    *
    * @see com.novell.servaluece.file.nw.VolumeUtilization
    */
    
   public void displayVolumeUtilization(VolumeUtilization value)
   {
      message("usedDirectories: " + value.getUsedDirectories());
      message("usedFiles: " + value.getUsedFiles());
      message("usedBlocks: " + value.getUsedBlocks());
      message("name: " + value.getName());
   }

   /**
    * Display a message to the user.  Displaying the value might be 
    * surpressed via a verbose flag in the actual implementation
    * 
    * @param value               value to display to the user
    */
    
   private void message(String value)
   {
      if (verbose)
      {
         System.out.println(value);
      }
   }
}