/***************************************************************************
 %name: Unbind.java
 %version: 
 %date_modified: 
 %dependencies: TextualStatic.java
  
 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;

import com.novell.utility.naming.Environment;

/** 
 * Example of explicit bindings
 *
 * <p>This program demonstrates how to explicitly bind foreign objects to
 * the file system providers Contexts.
 * </p>
 */

public class UnBind
{
   /**
    * UnBind example
    * 
    * <p>This example will unbind an object from the Context
    * specified in the url with the given name.
    * </p>
    *
    * @param   args[]
    * where    args[0]  url (url to unbind object from)
    *          args[1]  name (name of the object being unbound)
    */

    public static void main(String args[])
    {
      String url = args[0];
      String name = args[1];

      // see if user has given the URL and name on the command line
      if (args.length < 2)
      {
         help();
      }
      // Set the initial context factory to NetWareInitialContextFactory
      Hashtable systemProps = new Hashtable();
      systemProps.put(
         Context.INITIAL_CONTEXT_FACTORY, 
         Environment.FS_INITIAL_CONTEXT_FACTORY);

      systemProps.put(Context.PROVIDER_URL, url);
      try
      {
         // Look up the object named by the command line parameter.
         Context context = 
            (Context) new InitialContext(systemProps).lookup("");

         System.out.println("\nUnbinding object " + name + " from: " + url + "\n");

         // unbind the object with the given name
         context.unbind(name);
      } 
      catch (javax.naming.NamingException e)
      {
         System.out.println("\nException thrown: " + e);
         e.printStackTrace();
         System.exit(-1);
      }
      // new UnBind(args[0], args[1], new TextualStatic(true));
   }

   private static void help()
   {
      System.out.println(
         "\nTo use this example program enter the following:\n");
      System.out.println("\tjava UnBind <url> <name>\n");
      System.out.println(
         "\t\turl = name of the File System Context to unbind an object from");
      System.out.println("\t\t       my_server/my_volume/my_dir");
      System.out.println(
         "\t\tname = name of the object that you want to unbind");
      System.out.println("");
      System.exit(-1);
   }
}