/***************************************************************************
%name:
%version:
%date_modified:
%dependencies:

Copyright (c) 1998 Novell, Inc. All Rights Reserved.

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/
import java.util.*;
import javax.naming.*;
import com.novell.java.lang.*;

public class DumpException
{
   /**
   * Most exceptions that are thrown from NJCL will have a root cause embedded
   * in them. This method takes a Throwable and dumps it's exception trace,
   * then if the exception has a root cause it recursively calls itself with
   * the root cause. This method is VERY useful in determining the real cause
   * of an exception as often the exception caught by the application is just
   * a wrapper on the real root exception.
   */
   synchronized static public void dumpException(Throwable e)
   {
      System.out.flush();
      System.err.flush();
      System.out.println("Dumping Exception...");
      while(e != null)
      {
         e.printStackTrace();
         if (e instanceof HasRootCauses)
         {
            System.out.println("\nRoot causes...");
            Enumeration enum = ((HasRootCauses)e).getRootCauses();
            while (enum.hasMoreElements())
            {
               dumpException((Throwable)enum.nextElement());
            }
         }
         if (e instanceof HasRootCause)
            e = ((HasRootCause)e).getRootCause();
         else if (e instanceof NamingException)
            e = ((NamingException)e).getRootCause();
         else if(e instanceof java.rmi.RemoteException)
            e = ((java.rmi.RemoteException)e).detail;
         else
            e = null;
         if(e != null)
            System.out.println("Root cause...");
      }
      System.err.flush();
      System.out.flush();
   }
}
