/***************************************************************************
%name: NetWareObjectLister.java
%version: 1.0
%date_modified: 071598
%dependencies: MyEnvironment.java

Copyright (c) 1998 Novell, Inc. All Rights Reserved.

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;

import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

import com.novell.service.jncp.NSIException;
import com.novell.service.server.ServerDescription;
import com.novell.service.server.ServerVersions;
import com.novell.utility.naming.Environment;

class NetWareObjectLister
{
   public static void main(String[] argv)
   {
      /**********************************************************************
      * Demonstrates programmatic access to NetWare and NDS through JNDI.
      **********************************************************************
      * NDS
      * -- Lists the names of directory entries subordinate to an NDS object
      * -- Lists all attribute values of an NDS directory entry
      * -- Lists selected attribute values of an NDS directory entry
      * -- Lists the NDS trees available on the network
      **********************************************************************
      * Bindery
      * -- Lists all the Bindery objects
      **********************************************************************
      * Server
      * -- Lists all the servers on the network
      * -- Lists the attributes of a particular server
      */


      /**********************************************************************
      * NDS
      */

      System.out.println("\n**************************************************");
      System.out.println("NDS");
      System.out.println("**************************************************\n");

      // List the names of directory entries subordinate to an NDS object
      System.out.println("\n-- Listing the names of directory entries");
      System.out.println("   subordinate to "
            + MyEnvironment.TREE
            + "\n" 
         );

      Hashtable props = new Hashtable();
      props.put(Context.INITIAL_CONTEXT_FACTORY,
         Environment.NDS_INITIAL_CONTEXT_FACTORY);
      props.put(Context.PROVIDER_URL, MyEnvironment.TREE);
      try
      {
        /**
        * Gets a context and does a lookup that context casting it to
        * Object.
        */
         DirContext initialCtx = new InitialDirContext(props);
         Object obj = initialCtx.lookup(MyEnvironment.DISTINGUISHED_NAME);
         if(obj != null)
         {
            System.out.println("\nTree name: "
               + MyEnvironment.TREE
            );
            System.out.println("Object name: "
               + MyEnvironment.DISTINGUISHED_NAME
               + "\n"
            );
            DirContext currCtx = (DirContext) obj;
            NamingEnumeration enum = currCtx.list("");
            while (enum.hasMoreElements())
            {
               NameClassPair pair = (NameClassPair)enum.next();
               System.out.println(pair.getName());
            }
         }
         else
         {
            System.out.println("lookup() returned null.");
         }
      }
      catch (NamingException e)
      {
         System.out.println("\nException thrown: " + e);
      }

      // List all the attribute values of an NDS directory entry


      System.out.println("\n-- Listing all the attribute values of");
      System.out.println("   "
         + MyEnvironment.TREE
         + "\n" 
      );
      props.put(Context.INITIAL_CONTEXT_FACTORY,
         Environment.NDS_INITIAL_CONTEXT_FACTORY);
      props.put(Context.PROVIDER_URL, MyEnvironment.TREE);
      try
      {
         DirContext initialCtx = new InitialDirContext(props);
         System.out.println("\nTree name: "
            + MyEnvironment.TREE);
         System.out.println("Object name: "
            + MyEnvironment.DISTINGUISHED_NAME);
         Object obj = initialCtx.lookup(MyEnvironment.DISTINGUISHED_NAME);
         if(obj != null)
         {
         DirContext currDSCtx = (DirContext) obj;
            Attributes attrSet = currDSCtx.getAttributes("");
            System.out.println("\nThere are "
               + attrSet.size()
               + " attributes in this attribute set."
            );
            NamingEnumeration attrEnum = attrSet.getAll();
            while (attrEnum.hasMoreElements())
            {
               Attribute attr = (Attribute)attrEnum.next();
               System.out.println("\nAttribute ID: "
                  + attr.getID()
               );
               NamingEnumeration attrValueEnum = attr.getAll();
               while(attrValueEnum.hasMoreElements())
               {
                  Object value = attrValueEnum.nextElement();
                  System.out.print("Attribute Value: " + value);
                  System.out.println(" ("
                     + value.getClass().getName()
                     + ")"
                  );
               }
            }
         }
      }
      catch (NamingException e)
      {
         System.out.println("\nException thrown: " + e);
         e.printStackTrace();
      }


      // List selected attribute values of an NDS directory entry
      System.out.println("\n-- Listing selected attribute values of");
      System.out.println("   "
         + MyEnvironment.TREE
         + "\n" 
      );
      props.put(Context.INITIAL_CONTEXT_FACTORY, Environment.NDS_INITIAL_CONTEXT_FACTORY);
      props.put(Context.PROVIDER_URL, MyEnvironment.TREE);
      try
      {
         DirContext initialCtx = new InitialDirContext(props);
         System.out.println("\nTree name: "
            + MyEnvironment.TREE);
         System.out.println("Object name: "
            + MyEnvironment.DISTINGUISHED_NAME);
         Object obj = initialCtx.lookup(MyEnvironment.DISTINGUISHED_NAME);
         if(obj != null)
         {
            DirContext objDSCtx = (DirContext) obj;
            Attributes attrSet = objDSCtx.getAttributes("", MyEnvironment.ATTRIBUTES);
            NamingEnumeration attrEnum=attrSet.getAll();

            while(attrEnum.hasMoreElements())
            {
               Attribute attr = (Attribute)attrEnum.next();
               System.out.println("\nAttribute ID: "
               + attr.getID()
               );
               NamingEnumeration attrValueEnum = attr.getAll();
               while(attrValueEnum.hasMoreElements())
               {
                  Object value = attrValueEnum.nextElement();
                  System.out.println("Attribute Value: " + value);
               }
            }
         }
      }
      catch (NamingException e)
      {
         System.out.println("Exception thrown: " + e);
      }

      /**********************************************************************
      * Bindery
      */

      System.out.println("\n**************************************************");
      System.out.println("Bindery");
      System.out.println("**************************************************\n");

      // List all the Bindery objects
      System.out.println("\n-- Listing the Bindery objects associated with");
      System.out.println("   "
         + MyEnvironment.SERVER
         + "\n" 
      );
      props.put(Context.INITIAL_CONTEXT_FACTORY,
         MyEnvironment.BINDERY_INITIAL_CONTEXT_FACTORY);
      props.put(Context.PROVIDER_URL, MyEnvironment.SERVER);
      try
      {
         Context initialCtx = new InitialContext(props);
         System.out.println("Listing bindery objects of server "
            + MyEnvironment.SERVER
            + "\n"
         );
         NamingEnumeration enum = initialCtx.list("");
         while (enum.hasMoreElements())
         {
            NameClassPair pair = (NameClassPair)enum.next ();
            System.out.println(pair.getName());
         }
      }
      catch (NamingException e)
      {
         System.out.println("\nException thrown: " + e);
         e.printStackTrace();
      }

      /**********************************************************************
      * Server
      */
      System.out.println("\n**************************************************");
      System.out.println("Server");
      System.out.println("**************************************************\n");

      // List all servers
      System.out.println("\n-- Listing all the servers on the network\n");
      props.put(Context.INITIAL_CONTEXT_FACTORY,
      Environment.NW_INITIAL_CONTEXT_FACTORY);
      try
      {
         Context initialCtx = new InitialContext(props);
         Object obj = initialCtx.lookup(MyEnvironment.SERVERS_CANONICAL_NAME);
         if(obj != null)
         {
            Context ctx = (Context) obj;
            NamingEnumeration enum = ctx.list("");
            while (enum.hasMoreElements())
            {
               NameClassPair pair = (NameClassPair)enum.next();
               System.out.println(pair.getName());
            }
         }
         else
         {
            System.out.println("lookup() returned null.");
         }
      }
      catch (NamingException e)
      {
         System.out.println("\nException thrown: " + e);
      }

      // List the attributes of a particular server
      System.out.println("\n-- Listing the attributes and values of the server");
      System.out.println("   "
         + MyEnvironment.SERVER
         + "\n" 
      );
      props.put(Context.INITIAL_CONTEXT_FACTORY,
         Environment.SERVER_INITIAL_CONTEXT_FACTORY);
      props.put(Context.PROVIDER_URL, MyEnvironment.SERVER);
      try
      {
         DirContext initialDSCtx = new InitialDirContext(props);
         System.out.println("\nServer Name: "
            + MyEnvironment.SERVER
         );
         Attributes attrSet = initialDSCtx.getAttributes("");
         System.out.println("\nThere are "
            + attrSet.size()
            + " attributes in this attribute set.");
         NamingEnumeration attrEnum = attrSet.getAll();
         while(attrEnum.hasMoreElements())
         {
            Attribute attr = (Attribute)attrEnum.next();
            String attrID = attr.getID();
            System.out.println("\nThe attribute ID is: " + attrID);
            NamingEnumeration avEnum = attr.getAll();
            while(avEnum.hasMoreElements())
            {
               Object avObj = avEnum.nextElement();
               if(attrID.equals("ServerVersions"))
               {
                  ServerVersions serverVersions = (ServerVersions)avObj;
                  System.out.println("Major Version: "
                     + serverVersions.getMajorVersion());
                  System.out.println("Minor Version: "
                     + serverVersions.getMinorVersion());
                  System.out.println("Revision: "
                     + serverVersions.getRevision());
                  System.out.println("Account Version: "
                     + serverVersions.getAccountVersion());
                  System.out.println("Queue Vesion: "
                     + serverVersions.getQueueVersion());
                  System.out.println("Print Version: "
                     + serverVersions.getPrintVersion());
                  System.out.println("Virtual Console Version: "
                     + serverVersions.getVirtualConsoleVersion());
                  System.out.println("Security Version: "
                     + serverVersions.getSecurityVersion());
                  System.out.println("Internet Bridge Version: "
                     + serverVersions.getInternetBridgeVersion());
               }
               else
               if(attrID.equals("ServerDescription"))
               {
                  ServerDescription serverDescription  = (ServerDescription)avObj;

                  System.out.println("Company Name: "
                  + serverDescription.getCompanyName());
                  System.out.println("Revision: "
                  + serverDescription.getRevision());
                  System.out.println("Revision Date: "
                  + serverDescription.getRevisionDate());
                  System.out.println("Copyright Notice: "
                  + serverDescription.getCopyrightNotice());
               }
               else
               {
                  System.out.println(avObj);
               }
            }
         }
      }
      catch (NSIException nsie)
      {
         System.out.println("Exception: " + nsie);
      }
      catch (NamingException ne)
      {
         System.out.println("Exception: " + ne);
      }
   }
}