/* **************************************************************************
 %name: %
 %version: %
 %date_modified: %

 Copyright (c) 1997,1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import javax.naming.*;

/**
 * Contains an object and the name required to look it up.
 */
public class NamedObject
{
   Name name;
   Object obj;

  /**
   * Constructs a NamesObject based on the input name and
   * object.
   *
   * @param name The name of the object to look up.
   * @param obj  The object to be looked up.
   */
   public NamedObject (Name name, Object obj)
   {
      this.name = name;
      this.obj = obj;
   }

  /**
   * Returns the name used to look up an object.
   *
   * @param Name The name used to look up an object.
   */
   public Name getName ()
   {
      return (name);
   }

  /**
   * Returns the object looked up by the name.
   *
   * @return Object The object looked up by the name.
   */
   public Object getObject ()
   {
      return (obj);
   }
}
