/* **************************************************************************
 %name: %
 %version: %
 %date_modified: %

 Copyright (c) 1997,1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

/**
 * Used to pass error messages from a command to the shell.
 *
 * <p>If an error occurs in a command, a ShellException can be thrown
 * with a message. The name of the command along with the message
 * is then printed, and execution continues. If the 'exitShell' flag
 * is set, then the shell will exit.
 * </p>
 */
public class ShellException extends Exception
{
   boolean exitShell = false;

   /**
    * Construct a new ShellException, with no message, that will
    * not exit.
    */
   public ShellException ()
   {
      super ();
   }

   /**
    * Construct a new ShellException with no message but with
    * the exitShell flag as input parameter.
    *
    * @param exitShell A boolean that may be set to TRUE for
    *                  exiting the shell; otherwise set to FALSE,
    *                  which is the default.
    */
   public ShellException (boolean exitShell)
   {
      super ();

      this.exitShell = exitShell;
   }

   /**
    * Construct a new ShellException with a message that will not
    * exit.
    *
    * @param obj The message to be printed.
    */
   public ShellException (Object obj)
   {
      super (obj.toString ());
   }

   /**
    * Construct a new ShellException with a message and the
    * exitShell flag as input parameters.
    *
    * @param obj       The message to be printed.
    * @param exitShell A boolean that may be set to TRUE for
    *                  exiting the shell; otherwise set to FALSE,
    *                  which is the default.
    */
   public ShellException (Object obj, boolean exitShell)
   {
      super (obj.toString ());

      this.exitShell = exitShell;
   }

   /**
    * Returns TRUE if the shell should exit as a result of this
    * exception.
    *
    * @return A boolean set to TRUE if the shell should exit; 
    *         otherwise set to FALSE if the shell should not
    *         exit as a result of the exception.
    */
   public boolean shouldExit ()
   {
      return (exitShell);
   }
}
