import java.util.Hashtable;

import javax.naming.Context;
/* **************************************************************************
 %name: %
 %version: %
 %date_modified: %

 Copyright (c) 1997,1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import javax.naming.InitialContext;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

import com.novell.utility.naming.Environment;
import com.novell.service.nds.NdsCaseIgnoreString;

class Createuser
{  
   public static void main(String[] args)
   {
      try
      {
         if (args.length < 3)
            help();
            
         String url = args[0];
         String username = args[1];
         
         Hashtable hash = new Hashtable();
         hash.put(Context.INITIAL_CONTEXT_FACTORY,
            Environment.NDS_INITIAL_CONTEXT_FACTORY);
         hash.put(Context.PROVIDER_URL, url);
         
         InitialDirContext container = new InitialDirContext(hash);
         
         Attributes attrs = new BasicAttributes();
         attrs.put("Object Class", new NdsCaseIgnoreString("User"));
         attrs.put("Surname", new NdsCaseIgnoreString(args[2]));
         
         container.createSubcontext(username, attrs);
      }
      catch (Throwable t)
      {
         System.out.println("Threw something.");
         t.printStackTrace();
      }
   }

   public static void help()
   {
      System.out.println("\nCreateuser -- creates a user object in an NDS tree\n");
      System.out.println("usage: java createuser [provider_url] [name] [surname]\n");
      System.out.println("Overview");
      System.out.println("\nCreates a user with name [name] and surname [surname]");
      System.out.println("subordinate to the URL [provider_url].");
      System.exit(-1);
   }
}