/****************************************************************************
  $Archive: /njcl_sample/NJCLApplet/src/LookupFrame.java $
  $Revision: 2 $
  $Modtime: 3/18/99 2:16p $

  Copyright (c) 1999 Novell, Inc.  All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
 ***************************************************************************/

import java.util.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * This class provides a graphical input dialog for retrieving the lookup
 * string.
 */

public class LookupFrame
   extends JDialog
   implements ActionListener
{
   private static int buttonHeight = 25;
   private static int buttonWidth = 100;
   private static int mainPaneHeight = 100;
   private static int mainPaneWidth = 600;

   // Declare controls
   JButton     okButton;
   JButton     cancelButton;
   JLabel      lookupLabel;
   JTextField  lookupTextField;

   String lookupText;         // May be null or empty

   /**
    * Constructs the GUI portion of the lookup frame.
    */
   public LookupFrame (
         JFrame frame)
   {
      super (frame, "Lookup", true);
      getContentPane ().setLayout (new BorderLayout ());
      setSize (mainPaneWidth, mainPaneHeight);
      
      // Lookup label and field
      JPanel lookupPanel = new JPanel (new BorderLayout ());
      lookupLabel = new JLabel ("JNDI path");
      lookupLabel.setSize (buttonWidth, buttonHeight);
      lookupPanel.add (lookupLabel, "West");
      lookupTextField = new JTextField ();
      lookupTextField.setSize (buttonHeight, mainPaneWidth - buttonWidth);
      lookupPanel.add (lookupTextField, "Center");
      getContentPane ().add (lookupPanel, "North");

      // Buttons
      JPanel buttonPanel = new JPanel (new FlowLayout (FlowLayout.CENTER));
      okButton = new JButton ("OK");
      okButton.setToolTipText ("Lookup the named object");
      okButton.setSize (buttonWidth, buttonHeight);
      okButton.addActionListener (this);
      buttonPanel.add (okButton);
      
      cancelButton  = new JButton ("Cancel");
      cancelButton.setToolTipText ("Cancel the lookup operation");
      cancelButton.addActionListener (this);
      cancelButton.setSize (buttonWidth, buttonHeight);
      buttonPanel.add (cancelButton);
      getContentPane ().add (buttonPanel, "South");
      addWindowListener (new LookupWindowAdapter ());
      
   } // LookupFrame ()

   /**
    * Inner class for handling focus change and window close events.
    */
   class LookupWindowAdapter
      extends WindowAdapter
   {
      private boolean firstTime = true;
      
      public void windowActivated (WindowEvent event)
      {
         if (firstTime)
         {
            lookupTextField.requestFocus ();
            firstTime = false;
         }
      }

      public void windowClosing (WindowEvent event)
      {
         lookupText = null;
         setVisible (false);
      }
   } // class LookupWindowAdapter

   /**
    * ActionListener event handler method.
    */
   public void actionPerformed (
         ActionEvent event)
   {
      Object object = event.getSource ();
      if (object == okButton)
      {
         lookupText = lookupTextField.getText ();
         if (lookupText.equals (""))
            lookupText = null;
         setVisible (false);
      }
      else if (object == cancelButton)
      {
         lookupText = null;
         setVisible (false);
      }
   } // ActionListener.actionPerformed ()

   /**
    * Return the text entered (or NULL if none or cancel).
    *
    * @return                    The lookup string entered. May be NULL.
    */
   public String getText ()
   {
      return (lookupText);
   } // getText ()
   
} // class LookupFrame

