/****************************************************************************
  $Archive: /njcl_sample/NJCLApplet/src/NJCLApplet.java $
  $Revision: 2 $
  $Modtime: 3/18/99 4:13p $

  Copyright (c) 1999 Novell, Inc.  All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
 ***************************************************************************/

import java.util.*;

import javax.swing.*;

import javax.naming.*;
import javax.naming.directory.*;

import com.novell.utility.naming.Environment;

/**
 * This is the applet root for the NJCL demo applet. This applet is intended
 * to show off some of the more popular features of NJCL and the Novell
 * providers for JNDI.
 *
 * JNDI features demonstrated:
 * <ul)
 * <li>list
 * <li>lookup
 * <li>attributes
 * <li>search (not implemented yet)
 * <li>schema
 * </ul>
 *
 * Session Management
 * <ul>
 * <li>public session manager
 * </ul>
 *
 * Authentication
 * <ul>
 * <li>login()
 * <li>logout()
 * </ul>
 *
 * Services
 * <ul>
 * <li>NDS replica & partitions
 * <li>File streams
 * <li>Print queue file submission
 * <li>Server statistics
 * </ul>
 */

public class NJCLApplet
   extends JApplet
   implements InterfaceCompare
{
   ContextFrame rootFrame;
   static PopupHandler popupHandlers[];
   static String pluginParamStr = "plugins";

   static String[][] paramInfo = 
   {  // Array of strings describing each parameter
      {Environment.INITIAL_CONTEXT_FACTORY,"String","class name (with package) for initial context factory"},
      {Environment.PROVIDER_URL,"String (URL)","provider URL for initial context"},
      {Environment.AUTHORITATIVE,"Boolean","if true specifies most authoritative source is to be used"},
      {Environment.BATCHSIZE,"Unknown","specifies the preferred batch size to use when returning data"},
      {Environment.REFERRAL,"String","'follow', 'ignore' or 'throw'"},
      {Environment.SECURITY_AUTHENTICATION,"String","'none', 'simple', or 'strong'"},
      {Environment.SECURITY_PRINCIPAL,"String","user name"},
      {Environment.SECURITY_CREDENTIALS,"String","user tokens (password)"},
      {"java.naming.ldap.derefAliases","String","'never', 'searching', 'finding', 'always'"},
      {pluginParamStr,"String","semi-colon delimited list of plugin classes"}
   };
   
   /**
    * Init method called by applet manager.
    */
   public void init ()
   {
      int i;
      
      // This line prevents the "Swing: checked access to system event queue"
      //  message seen in some browsers.
      getRootPane ().putClientProperty (
                        "defeatSystemEventQueueCheck",
                        Boolean.TRUE);

      // Initialize our properties based on the system properties and those
      //  we've got as defaults and those we've been passed as parameters
      Properties props = Util.getPropertiesFromParams (this, paramInfo);
      
      // Combine our defaults with the applet params, keeping the applet
      //  params if specified
      props = Util.mergeProperties (
                        props,
                        getDefaultProperties (),
                        true);     // preserve
      
      // If the plugins are specified in the HTML use them first
      Object[] temp = Util.loadExtensions (this, props, pluginParamStr);
      if (null == temp)
      {  // Not specified in the parameters so try the directory (app) method
         try
         {
            temp = Util.loadExtensions (this, "plugins");
         }
         catch (Throwable e)
         {
            System.out.println (
                           "Unable to load extensions from file system:\n" +
                           Util.getExceptionTrace (e));
         }
      }
      if (null != temp)
         popupHandlers = new PopupHandler [temp.length];
      else
         popupHandlers = new PopupHandler [0];
      for (i = 0; i < popupHandlers.length; i++)
      {  // Copy needed for type safety of array parameter
         popupHandlers[i] = (PopupHandler) temp[i];
      }

      // Now we need to get the browser stuff started
      try
      {
         AboutFrame.getAboutFrame (getCodeBase ());
         ContextTreeNode treeNode = new ContextTreeNode (
                                             (ContextFrame) null,
                                             "Root");
         Hashtable hash = Util.getHashtableFromProperties (props);
         Context ctx = new InitialContext (hash);
         ctx = (Context) ctx.lookup ("");    // Turn it into a real context
         treeNode.setThisContext (ctx);
         rootFrame = new ContextFrame (treeNode);
         rootFrame.setStatusLabel (
                        "Initial Context: " +
                        props.getProperty (Context.INITIAL_CONTEXT_FACTORY));
         rootFrame.setRootFlag (true);
         rootFrame.show ();
      } catch (NamingException e)
      {
         (new MessageBox (
                  "Error",
                  "Unable to initialize JNDI:\n" +
                  Util.getExceptionTrace (e))).show ();
      }
   } // init ()

   /**
    * Return information about the supported parameters for this applet
    *
    * @return                    Array of parameter description strings.
    */
   public String[][] getParameterInfo ()
   {
      return (paramInfo);
   } // getParameterInfo ()
   
   /**
    * Return information about the application suitable for an about dialog.
    */
   public String getAppletInfo ()
   {
      return ("NJCLApplet demo, v1.0. Written by Novell Inc.\n" +
              "Copyright 1999. All Rights Reserved.");
   }

   // InterfaceCompare methods -----------------------------------------------
   /**
    * Method called to determine if a class impelemnts a given interface.
    *
    * @param obj                 The object to be checked.
    * @return                    True if the object implements the right
    *                            interface.
    */
   public boolean implementsInterface (
         Object obj)
   {
      return (obj instanceof PopupHandler);
   } // implementsInterface ()

   // Static methods ---------------------------------------------------------
   /**
    * Returns the default properties for this applet.
    *
    * @return                    A set of default, or hard-coded properties.
    */
   static Properties getDefaultProperties ()
   {
      Properties props = new Properties ();
      props.put (
               Context.INITIAL_CONTEXT_FACTORY,
               Environment.NW_INITIAL_CONTEXT_FACTORY);
      props.put ("plugins", "DataPopupHandler");
      return (props);
   } // getDefaultProperties ()

   /**
    * This method allows the applet to be launched as an application.
    *
    * @params args               The command line arguments to the app.
    */
   public static void main (
         String args[])
   {
      NJCLApplet app = new NJCLApplet ();
      app.init ();
   } // main ()

} // class NJCLApplet
