/****************************************************************************
  $Archive: /njcl_sample/NJCLApplet/src/plugins/AuthPopupHandler.java $
  $Revision: 2 $
  $Modtime: 3/11/99 3:42p $

  Copyright (c) 1999 Novell, Inc.  All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
 ***************************************************************************/

import java.io.*;
import java.util.*;
import java.awt.event.*;

import javax.swing.*;
import javax.naming.*;

import com.novell.java.security.Identity;
import com.novell.java.security.Authenticator;
import com.novell.utility.naming.Environment;
import com.novell.service.session.Session;
import com.novell.service.ldap.LdapCtx;

/**
 * This class provides a 'snap-in' that keys off of a popup menu for
 * authentication.
 */
public class AuthPopupHandler
   implements PopupHandler
{
   /**
    * Required public, null constructor.
    */
   public AuthPopupHandler ()
   {
   }
   
   /**
    * Method called for registered handlers when the popup event occurs.
    *
    * @param frame               The frame in which the popup is being
    *                            requested.
    * @param popup               The popup menu being created. If the handler
    *                            wants to provide custom handling for the
    *                            object being passed, it can add one or more
    *                            to this menu before returnning. Otherwise
    *                            it can ignore this request.
    * @param obj                 The object being customized. This is likely
    *                            to be a ContextTreeNode.
    */
   public void popupRequested (
      JFrame frame,
      JPopupMenu popup,
      Object obj)
   {
      //System.out.println (
      //            "AuthPopupHandler called with " +
      //            obj.getClass ().getName ());
                  
      Context ctx = null;
                        
      if (obj instanceof ContextTreeNode)
         ctx = ((ContextTreeNode) obj).getThisContext ();
      if (null != ctx)
      {
         try
         {  // See if this is a NetWare session-oriented class
            Hashtable hash = ctx.getEnvironment ();
            Object session = hash.get (Environment.SESSION_OBJECT);
            if ((null != session) &&
                (session instanceof Session))
            {
               new NWAuthActionListener (
                        frame,
                        (ContextTreeNode) obj,
                        (Session) session,
                        popup);
            }
            else if (ctx instanceof LdapCtx)
            {
//               new LdapAuthActionListener (
//                        ctx,
//                        popup);
            }
         }
         catch (Exception e)
         {  // Don't do anything, just give up - we tried
         }
      }
   } // popupRequested ()
   
} // class AuthPopupHandler

/**
 * Internal class to handle NetWare session style authentication.
 */
class NWAuthActionListener
   implements ActionListener
{
   ContextFrame frame;
   ContextTreeNode treeNode;
   Session session;
   JMenuItem loginMenuItem;
   JMenuItem logoutMenuItem;

   /**
    * Public, default constructor required for plugins.
    *
    * <p>Even though this is not a plug-in, it is in the plug-in directory.
    * </p>
    */
   public NWAuthActionListener () {}

   /**
    * Constructor which hangs onto the session.
    *
    * @param frame               The frame in which the popup is being
    *                            requested.
    * @param treeNode            The component object being operated on.
    *                            This should be a ContextTreeNode.
    * @param session             The session object to be logged in or out.
    * @param popup               The popup menu being created. If the handler
    *                            wants to provide custom handling for the
    *                            object being passed, it can add one or more
    *                            to this menu before returnning. Otherwise
    *                            it can ignore this request.
    */   
   public NWAuthActionListener (
         JFrame frame,
         ContextTreeNode treeNode,
         Session session,
         JPopupMenu popup)
   {
      if (frame instanceof ContextFrame)
         this.frame = (ContextFrame) frame;
      else
         this.frame = null;         // Refresh is not supported
      this.treeNode = treeNode;
      this.session = session;
      loginMenuItem = new JMenuItem ("Login");
      loginMenuItem.setToolTipText ("Login the session for this object");
      loginMenuItem.addActionListener (this);
      popup.add (loginMenuItem);
      logoutMenuItem = new JMenuItem ("Logout");
      logoutMenuItem.setToolTipText ("Logout the session for this object");
      logoutMenuItem.addActionListener (this);
      popup.add (logoutMenuItem);
   } // NWAuthActionListener ()

   // ActionListener methods ------------------------------------------------
   /**
    * ActionListener event handler method.
    *
    * @param event               The event describing what action occured.
    */
   public void actionPerformed (
         ActionEvent event)
   {
      Object object = event.getSource ();
   
      if (object == loginMenuItem)
         login_Action (event);
      else if (object == logoutMenuItem)
         logout_Action (event);
   } // actionPerformed ()

   /**
    * Action handler for the login menu item.
    *
    * @param event               The event describing what action occured.
    */
   void login_Action (
         ActionEvent event)
   {
      try
      {
         Identity id = session.createIdentity ("");
         Authenticator.login (id);
         
         // If we're successful we'll need to refresh the tree view
         if (null != frame)
            frame.refreshMenuItem_Action ((ActionEvent) null);
      }
      catch (Exception e)
      {
         (new MessageBox (
                  "Error",
                  "Unable to login this object:\n" +
                  Util.getExceptionTrace (e))).show ();
      }
   } // login_Action ()
   
   /**
    * Action handler for the logout menu item.
    *
    * @param event               The event describing what action occured.
    */
   void logout_Action (
         ActionEvent event)
   {
      try
      {
         Identity id = session.createIdentity ("");
         Authenticator.logout (id);
         
         // If we're successful we'll need to refresh the tree view
         if (null != frame)
            frame.refreshMenuItem_Action ((ActionEvent) null);
      }
      catch (Exception e)
      {
         (new MessageBox (
                  "Error",
                  "Unable to logout this object:\n" +
                  Util.getExceptionTrace (e))).show ();
         e.printStackTrace ();
      }
   } // logout_Action ()
   
} // class NWAuthActionListener

/**
 * Internal class to handle Ldap style authentication.
 */
//class LdapAuthActionListener
//   implements ActionListener
//{
//   LdapCtx ctx;
//   JMenuItem loginMenuItem;
//   JMenuItem logoutMenuItem;
//
//   /**
//    * Public, default constructor required for plugins.
//    *
//    * <p>Even though this is not a plug-in, it is in the plug-in directory.
//    * </p>
//    */
//   public LdapAuthActionListener () {}
//
//   /**
//    * Constructor which hangs onto the context.
//    *
//    * @param ctx                 The LdapCtx to be logged in or out.
//    * @param popup               The popup menu being created. If the handler
//    *                            wants to provide custom handling for the
//    *                            object being passed, it can add one or more
//    *                            to this menu before returnning. Otherwise
//    *                            it can ignore this request.
//    */   
//   public LdapAuthActionListener (
//         LdapCtx ctx,
//         JPopupMenu popup)
//   {
//      this.ctx = ctx;
//      loginMenuItem = new JMenuItem ("Login");
//      loginMenuItem.setToolTipText ("Login to this context");
//      loginMenuItem.addActionListener (this);
//      popup.add (loginMenuItem);
//      logoutMenuItem = new JMenuItem ("Logout");
//      logoutMenuItem.setToolTipText ("Logout from this context");
//      logoutMenuItem.addActionListener (this);
//      popup.add (logoutMenuItem);
//   } // LdapAuthActionListener ()
//
//   // ActionListener methods ------------------------------------------------
//   /**
//    * ActionListener event handler method.
//    *
//    * @param event               The event describing what action occured.
//    */
//   public void actionPerformed (
//         ActionEvent event)
//   {
//      Object object = event.getSource ();
//   
//      if (object == loginMenuItem)
//         login_Action (event);
//      else if (object == logoutMenuItem)
//         logout_Action (event);
//   } // actionPerformed ();
//
//   /**
//    * Action handler for the login menu item.
//    *
//    * @param event               The event describing what action occured.
//    */
//   void login_Action (
//         ActionEvent event)
//   {
//      try
//      {
//         Identity id = new session.createIdentity ("");
//         Authenticator.login (id);
//      }
//      catch (Exception e)
//      {
//         (new MessageBox (
//                  "Error",
//                  "Unable to login this object:\n" +
//                  Util.getExceptionTrace (e))).show ();
//      }
//   } // login_Action ()
//   
//   /**
//    * Action handler for the logout menu item.
//    *
//    * @param event               The event describing what action occured.
//    */
//   void logout_Action (
//         ActionEvent event)
//   {
//      try
//      {
//         Identity id = session.createIdentity ("");
//         Authenticator.logout (id);
//      }
//      catch (Exception e)
//      {
//         (new MessageBox (
//                  "Error",
//                  "Unable to logout this object:\n" +
//                  Util.getExceptionTrace (e))).show ();
//         e.printStackTrace ();
//      }
//   } // logout_Action ()
//   
//} // class NWAuthActionListener
