/****************************************************************************
  $Workfile: NSIForm.java $
  $Revision: 1 $
  $Modtime:: $
  $Copyright:

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.$

 ***************************************************************************/

import java.awt.*;

/**
 * This class provides a common way for entry forms to be created.
 */

class NSIForm 
{
   Frame f;
   int row = 0;

   NSIForm
   (
      Frame f
   )
   {
      this.f = f;
      f.setLayout (new GridBagLayout ());
   }

   TextField addRow
   (
      String label
   )
   {
      TextField textField = new TextField (5);
      makeButton (f, new Label (label), 0, row, 1, 1, 0.0, 0.0);
      makeButton (f, textField, 1, row++, 1, 1, 1.0, 0.0);
      return textField;
   }

   void addRow
   (
      Object c
   )
   {
     makeButton (f, c, 1, row++, 1, 1, 1.0, 0.0);
   }

   void addRow
   (
      Object c,
      boolean leftjust
   )
   {
     if (leftjust)
       makeButton (f, c, 0, row++, 1, 1, 1.0, 0.0);
     else
       makeButton (f, c, 0, row++, 2, 1, 1.0, 0.0);
   }

   void show
   (
   )
   {
      f.pack();
      f.show();
   }

   static void makeButton
   (
      Container cont,
      Object arg,
      int x,
      int y,
      int w,
      int h,
      double weightx,
      double weighty
   )
   {
      GridBagLayout gbl = (GridBagLayout)cont.getLayout();
      GridBagConstraints c = new GridBagConstraints();
      Component comp;

      c.fill = GridBagConstraints.BOTH;
      c.gridx = x;
      c.gridy = y;
      c.gridwidth = w;
      c.gridheight = h;
      c.weightx = weightx;
      c.weighty = weighty;
      if (arg instanceof String) 
      {
         comp = new Button ((String) arg);
      } else 
      {
         comp = (Component) arg;
      }
      cont.add (comp);
      gbl.setConstraints (comp, c);
   } // makeButton ()

} // NSIForm
