/****************************************************************************
  $Workfile: NSILookupFrame.java $
  $Revision: 1 $
  $Modtime:: $
  $Copyright:

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.$

 ***************************************************************************/

import java.awt.*;
import java.awt.event.*;

import javax.naming.*;

/**
 * This class handles the looking up of an object for JNDI.
 */

public class NSILookupFrame extends Frame
                            implements WindowListener,
                            ActionListener
{
   public static final int width = 350;
   public static final int height = 75;

   NSIBrowserFrame parent;
   Context initCtx;
   Context currCtx;

   TextField objectNameField;
   Button okButton = new Button ("OK");
   Button cancelButton = new Button ("Cancel");

   /**
    * Constructor for the lookup frame.
    *
    * @param     parent          (in) The parent frame
    */
   public NSILookupFrame
   (
      NSIBrowserFrame parent,
      Context initCtx,
      Context currCtx
   )
   {
      super ("Lookup");
      this.parent = parent;      // Save the parent
      this.initCtx = initCtx;    // Save the (relative) initial context
      this.currCtx = currCtx;    // Save the current context

      NSIForm f = new NSIForm (this);

      // Set up the entry for the user with the current value
      objectNameField = f.addRow ("Object path:");

      // NOTE: Here we could get the current path to shorten the user's work

      // Setup the ok and cancel buttons
      Panel p = new Panel ();
      p.setLayout (new GridLayout (1, 0));
      p.add (okButton);
      p.add (cancelButton);
      f.addRow (p);

      // Setup the Listeners
      addWindowListener (this);
      okButton.addActionListener (this);
      cancelButton.addActionListener (this);
   } // NSILookupFrame ()

   /**
    * This is the action handler for the initial context window (frame).
    *
    * @param     evt             (in) The event
    */
   public void actionPerformed (
      ActionEvent evt)
   {
      Object target = evt.getSource();
      // Handle the button actions
      if (target == okButton)
      {
         String objectName = objectNameField.getText ();

         // We need to see if the user wants relative or not
         Context relCtx = initCtx;

         if ('.' == objectName.charAt (0))
         {  // Yep, relative was requested
            objectName = objectName.substring (1);
            relCtx = currCtx;
         }
         try
         {
            Object obj = relCtx.lookup (objectName);
            if (obj instanceof Context)
               parent.startNewContextFrame (objectName, (Context) obj);
            else
               new NSIMessageBox ("Object not of type Context");
         }
         catch (NamingException e)
         {
            new NSIMessageBox ("Error", "Name not found:" + objectName);
         }

         // Close the window and return to the main window (frame).
         dispose();
      }
      else if (target == cancelButton)
      {
         // Close the window and return to the main window (frame).
         dispose();
      }
   } // action ()

   /**
    * Implement WindowListener functions.  We really only want the
    * windowClosing one.
    */

   public void windowClosed (
      WindowEvent event)
   {
   }

   public void windowDeiconified (
      WindowEvent event)
   {
   }

   public void windowIconified (
      WindowEvent event)
   {
   }

   public void windowActivated (
      WindowEvent event)
   {
   }

   public void windowDeactivated (
      WindowEvent event)
   {
   }

   public void windowOpened (
      WindowEvent event)
   {
   }

   public void windowClosing (
      WindowEvent event)
   {
      dispose ();
   }

} // class NSILookupFrame
