/****************************************************************************
  $Workfile: NSISpecialHandler.java $
  $Revision: 1 $
  $Modtime:: $
  $Copyright:

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.$

 ***************************************************************************/

import javax.naming.*;

/**
 * This class defines an interface for special handlers. A special handler
 * is designed to handle the specifics of a particular object type. This
 * object type is defined by object class and the binding is stored as a
 * property in the browser's configuration file or system properties.
 */

public interface NSISpecialHandler
{
   /**
    * The NSISpecialHandler initialize method.
    *
    * @param name             (in) Relative name for the object.
    * @param obj              (in) The object to be handled.
    * @returns                True if initialization was successful.
    *                         False otherwise which indicates not to
    *                         call the handleObject method.
    */
   public boolean initialize (Name name, Object obj);

   /**
    * Over-rides the NSISpecialHandler handleObject method.
    */
   public void handleObject ();
} // interface NSISpecialHandler
