/***************************************************************************
%name: QueueJob.java
%version: 
%date_modified: 
%dependencies: none

Copyright (c) 1998 Novell, Inc. All Rights Reserved.

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.naming.*;
import javax.naming.directory.*;
import com.novell.utility.naming.Environment;
import com.novell.service.qms.QMSJob;
import com.novell.service.qms.QMSOutputStream;
import com.novell.service.qms.QMSQueue;
import com.novell.service.qms.naming.QMSEnvironment;

/** 
* This class reads an existing file and 
* sends it to a print queue on the specified server.
*/
public class QueueJob
{
   /**
   * QueueJob example
   *
   * <p>This example creates a job in an existing queue
   * </p>
   *
   * @param   args[]
   * where    args[0]  serverName
   *          args[1]  queueName
   *          args[2]  fileName
   */
   public static void main(String args[])
   {
      String serverName = args[0];
      String queueName  = args[1];
      String fileName   = args[2];

      Hashtable hash = new Hashtable(4);
      hash.put(Context.INITIAL_CONTEXT_FACTORY, Environment.QMS_INITIAL_CONTEXT_FACTORY);
      hash.put(Context.PROVIDER_URL, serverName);
      hash.put(QMSEnvironment.QUEUE_NAME, queueName);

      try
      {
         QMSQueue testQueue = (QMSQueue) new InitialDirContext(hash).lookup("");

         QMSJob job = testQueue.createJob();
         job.setDescription("Using JNDI to print a job.");

         QMSOutputStream os = job.submit();

         FileInputStream fis = new FileInputStream(fileName);
         byte[] inbuf = new byte[4096];
         fis.read(inbuf);

         os.write( inbuf );
         os.close();
      }
      catch ( Exception e )
      {
         e.printStackTrace();
      } 
   }      
}
