/***************************************************************************
 %name:
 %version:
 %date_modified:
 %dependencies:

 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;

import com.novell.utility.naming.Environment;
import com.novell.service.server.NWServer;

/**
 * Finds a server and loads an NLM as specified on the command line.
 */
public class LoadNLM
{
   /**
    * Demonstrates loading an NLM remotely on a specified server
    * using Java. The user must have console operator privileges to
    * load NLMs remotely.
    *
    * @param argv The command line, which specifies the server name
    *             and the NCP extension name; argv[0] = Server name
                  (for example, MYSERVER), and argv[1] = NLM name
                  (for example, MONITOR).
    */
   public static void main(String argv[])
   {
      if(argv.length < 2)
      {
         System.out.println("Error: missing parameters");
         System.out.println("Usage: java LoadNLM <servername> <nlm>");
         System.exit(1);
      }

      try
      {
         String serverName = argv[0];
         String nlmName = argv[1];

        /* First get a NetWare initial context.
         */
         Hashtable hash = new Hashtable();
         hash.put(Context.INITIAL_CONTEXT_FACTORY, Environment.NW_INITIAL_CONTEXT_FACTORY);
         Context initCtx = new InitialContext(hash);

         /* Lookup the server for which the user passed in the name, 
          * narrowing it to NWServer.
          */
         NWServer server = (NWServer) initCtx.lookup ("Servers/" + serverName);

         server.loadNLM(nlmName);
         System.out.println("Successfully loaded " + nlmName + " on server " + serverName);
      }
      catch(Exception e)
      {
         System.out.println("Exception occured: " + e);
         e.printStackTrace();
      }
   }
}
