
import java.util.*;

import javax.naming.*;
import javax.naming.directory.*;

import com.novell.java.security.*;

import com.novell.service.nds.*;
import com.novell.service.nds.naming.*;

import com.novell.service.security.*;

import com.novell.service.session.*;
import com.novell.service.session.nds.*;

import com.novell.utility.naming.Environment;


/**
 *
 */
class NdsServerSessionInfo
{
   private static String serverName;

   private static String[] attrIds = 
      new String[] {
                        NDS.SERVER_INFO_DS_VERSION_ATTR_ID,
                        NDS.SERVER_INFO_DN_ATTR_ID};

   /**
    *
    */
   private static void usage (
         String[] args)
   {
      if (args.length != 1)
      {
         System.out.println ("usage: java NdsServerSessionInfo <ServerName>");
         System.exit (-1);
      }
      serverName = args[0];
   }

   /**
    *
    */
   public static void main (
         String[] args)
   {
      // given serverName
      usage (args);

      System.out.println ("ServerName: " + serverName);
      System.out.println ();

      try
      {
         Enumeration enum;
         Session session;
         SessionManager manager;
         SessionEnv environment = new SessionEnv ();
         SessionAttrs attrs;
         SessionAttr attr;

         environment.put (
                        SessionEnv.INITIAL_SESSION_FACTORY,
                        "com.novell.service.session.nds.NDSInitialSessionFactory");

         manager = SessionManagerFactory.getSessionManager (environment);

         session = manager.getSession (serverName);

         // Explict Attributes
         attrs = session.getAttributes (attrIds);

         for (int i = 0; i < attrIds.length; i++)
         {
            try
            {
               attr = attrs.get (attrIds[i]);
               System.out.println (attr);
            }
            catch (SessionAttrNotFoundException e)
            {
               e.printStackTrace ();
            }
         }

         // All Attributes
         attrs = session.getAttributes ();
         enum = attrs.getAttributes ();

         while (enum.hasMoreElements ())
         {
            attr = (SessionAttr) enum.nextElement ();

            System.out.println (attr);
         }

         System.out.println ();
      }
      catch (SessionException e)
      {
         e.printStackTrace ();
         System.exit (-2);
      }

      System.exit (0);

   } /* Main () */

} /* ServerContainer */

