/* **************************************************************************
 %name: %
 %version: %
 %date_modified: %

 Copyright (c) 1997,1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import java.io.*;

public class LineReader
{
   InputStream is = null;
   Reader ir = null;
   char[] lineTerminator = System.getProperty ("line.separator").
         toCharArray ();

   public LineReader (InputStream is)
   {
      this.is = is;
   }

   public LineReader (Reader ir)
   {
      this.ir = ir;
   }

   private int read ()
   throws IOException
   {
      if (is != null)
         return (is.read ());
      else if (ir != null)
         return (ir.read ());
      else
         throw new IllegalStateException ();
   }

   public String readLine ()
   throws IOException
   {
      StringBuffer buf = new StringBuffer ();
      char[] save = new char[lineTerminator.length];
      int pos = 0;
      int ch = read ();
      boolean done = false;

      if (ch < 0)
         return (null);

      do
      {
         if (ch == lineTerminator[pos])
         {
            save[pos] = (char) ch;
            pos++;
         }
         else
         {
            // if a char in the line terminator is returned
            //   but one was skipped, then skip it by moving pos
            //   up by two
            if (pos + 1 < lineTerminator.length &&
                ch == lineTerminator[pos + 1])
               pos += 2;
            else
            {
               if (pos > 0)
               {
                  buf.append (save, 0, pos);
                  pos = 0;
               }

               buf.append ((char) ch);
            }
         }

         done = pos >= lineTerminator.length;

         if (!done)
            ch = read ();

         if (ch < 0)
            done = true;
      } while (!done);

      return (new String (buf));
   }
}