
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/java/lang/HasRootCause.java $
  $Revision: 5 $
  $Modtime: 1/14/00 4:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.java.lang;


/**
 * Provides an interface that can be implemented by classes having
 * root cause exceptions. HasRootCause is typically implemented by
 * throwable classes wanting to report the exception into which a
 * new exception is wrapped.
 *
 * @see HasRootCauses
 */
public interface HasRootCause
{
  /**
   * Returns the stored root cause as a Throwable object.
   *
   * @return The root cause; NULL if none exists.
   */
   public Throwable getRootCause ();

} /* HasRootCause */


