/* **************************************************************************

  $Archive: /njcl/src/com/novell/java/security/AuthenticatorProtocol.java $
  $Revision: 7 $
  $Modtime: 7/21/99 11:49a $

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.java.security;

import java.util.Properties;

/**@internal
 *
 * Authentication protocols implement this interface which allows
 * the <code>Authenticator</code> to load the protocol and perform
 * authentication via the protocol.
 *
 *
 * @author  Jan Sture Nielsen
 * @version 1.0.0 97/11/01
 *
 * @see Authenticator
 * @see AuthenticatorChannel
 */
public interface AuthenticatorProtocol
{
   /**
    * configure the protocol at construction
    *
    * @param properties defining properties for the protocol
    * @param baseKey base key for the defining properties
    */
   void configure(Properties properties,String baseKey)
		throws ConfigurationException;

   /**
    * initialize the protocol at runtime
    *
    * @param channel authentication channel to be used in the authentication protocol
    * @param identity entity on whose behalf the protocol should be performed
    *
    * @exception InvalidAuthenticatorChannelException channel is not supported by protocol
    */
   void init(AuthenticatorChannel channel) 
      throws InvalidAuthenticatorChannelException;

   /**
	 * channel across which the protocol should run
	 *
	 * @returns AuthenticatorChannel protocol's channel
	 */
	AuthenticatorChannel getChannel();

	/**
	 * get the authenticated identity(ies) of the configured scope
	 *
	 * @param identity identity on whose behalf the login should occur
	 *
	 * @returns Identity[] identities authenticated in the scope
	 */
   Identity[] getIdentities(Identity identity)
      throws AuthenticatorException;

	/**
	 * login the identity to the configured scope
	 *
	 * @param identity identity on whose behalf the login should occur
	 */
   void login(Identity identity)
      throws LoginException;

	/**
	 * create the tokens for the identity in the configured scope
	 *
	 * @param identity identity whose tokens should be created
	 *
     * @deprecated This API should not be used, and may not work on some platforms. 
     * It has been replaced with <code>createTokens(Identity admin, Identity user)</code>
	 */
   void createTokens(Identity identity)
      throws CreateTokensException;

	/**
	 * create the tokens for the identity in the configured scope
	 *
	 * @param admin 	The Identity object (typically, one with admin rights) whose 
	 *					permissions are to be used for creating <code>user</code> tokens.
	 * @param user      The Identity object whose login tokens are to be created.
	 * @exception 		CreateTokensException if tokens creation failed.
	 *
	 */
   void createTokens(Identity admin, Identity user)
      throws CreateTokensException;

 
	/**
	 * modify the tokens for the identity in the configured scope
	 *
	 * @param identity identity whose tokens should be modified
	 */
   void modifyTokens(Identity identity)
      throws ModifyTokensException;

	/**
	 * verify the tokens for the identity in the configured scope
	 *
	 * @param identity identity whose tokens should be verified
	 */
   void verifyTokens(Identity identity)
      throws VerifyTokensException;

	/**
	 * logout the identity from the configured scope
	 *
	 * @param identity identity on whose behalf the logout should occur
	 */
   void logout(Identity identity)
      throws LogoutException;
}
