/* **************************************************************************

  $Archive: /njcl/src/com/novell/java/security/I2L.java $
  $Revision: 5 $
  $Modtime: 5/21/98 6:16p $

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.java.security;

import java.util.ResourceBundle;

/**@internal
 *
 * I18n/L10n ResourceBundle mapper
 *
 * @author Jan Sture Nielsen
 * @version 1.0.0 98/03/04
 */
public class I2L
{
   /**
	 * related resource bundle
	 */
	final static ResourceBundle res = ResourceBundle.getBundle("com.novell.java.security.XMsg");

   /**
    * return localized string given the internationalized key
    *
    * @param      key		international key from the resource bundle
    * @return     localized string corresponding to internationalized key
    */
   public static String getString(String key)
   {
      return res.getString(key);
   }

   /**
    * return localized object given the internationalized key
    *
    * @param      key		interantional key from the resourceBundle
    * @return     localized object corresponding to internationalized key
    */
   public static Object getObject(String key)
   {
      return res.getObject(key);
   }
}
