/*
 * @(#)Principal.java	1.13 97/08/07
 * 
 * Copyright 1993-1997 Sun Microsystems, Inc. 901 San Antonio Road, 
 * Palo Alto, California, 94303, U.S.A.  All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * CopyrightVersion 1.2
 * 
 */

package com.novell.java.security;

/**
 * Represents a principal, which can be an individual, a corporation,
 * a program thread, or anything that can have an identity.
 *
 * @see Identity
 *
 * @version 1.13, 97/11/07
 * @author Satish Dharmaraj 
 */
public interface Principal 
{
    /**
     * Compares two Objects for equality. The equals method compares
     * this principal value with the value of the specified Object in
     * the another parameter.
     *
     * <p>The equals method implements the most discriminating possible
     * equivalence relation on objects; that is, for any reference values
     * X and Y, this method returns TRUE if and only if X and Y refer to
     * the same object (X==Y has the value TRUE).</p>
     *
     * @param another The reference object with which to compare.
     * 
     * @return A boolean set to TRUE if and only if the argument
     *         (principal) passed-in is not NULL and contains the
     *         same value as that encapsulated by this principal,
     *         otherwise set to FALSE.
     */
    public boolean equals(Object another);
    
    /**
     * Generates a string representation of the object (principal).
     * It returns a string that textually represents the object. The
     * result should be a concise but informative representation
     * that is easy to read.
     *
     * @return The String representation of this object (principal).
     */
    public String toString();

    /**
     * Returns a hash code value for this object (principal).
     * Whenever the hashCode() method is invoked on the same
     * object more than once during an execution of a Java
     * application, the hashCode() method must consistently return
     * the same integer. This integer need not remain consistent 
     * from one execution of an application to another execution
     * of the same application. If two objects are equal according
     * to the equals() method, then calling the hashCode() method on
     * each of the two objects must produce the same integer result.
     *
     * @return A hash code value for this object (principal).
     */
    public int hashCode();

    /**  
     * Returns the name of this principal.
     *
     * @return The name of this principal.
     */
    public String getName();
}
