/* **************************************************************************

  $Archive: /njcl/src/com/novell/java/security/XMsg.java $
  $Revision: 7 $
  $Modtime: 2/25/99 7:04p $

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.java.security;

import java.util.ListResourceBundle;

/**@internal
 *
 * localization resource for the security package
 *
 * @author Jan Sture Nielsen
 * @version 1.0.0 98/03/04
 */
public class XMsg extends ListResourceBundle
{
	/**
	 * list of keys which should NOT be localized
	 */
	public final static String
		ALREADY_AUTHENTICATED					= "ALREADY_AUTHENTICATED",
		ANOTHER_IDENTITY_IS_AUTHENTICATED	= "ANOTHER_AUTHENTICATED",
		AUTHENTICATOR								= "AUTHENTICATOR",
		AUTHENTICATOR_CHANNEL					= "AUTHENTICATOR_CHANNEL",
		AUTHENTICATOR_PROTOCOL					= "AUTHENTICATOR_PROTOCOL",
		CONFIGURATION								= "CONFIGURATION",
		CREATE_TOKENS								= "CREATE_TOKENS",
		CREATE_TOKENS_CANCELLED					= "CREATE_TOKENS_CANCELLED",
      CHANNEL_PARSING							= "CHANNEL_PARSING",
		GET_IDENTITIES								= "GET_IDENTITIES",
		IDENTITY_PARSING							= "IDENTITY_PARSING",
		INVALID_AUTHENTICATOR_CHANNEL			= "INVALID_AUTHENTICATOR_CHANNEL",
		INVALID_AUTHENTICATOR_PROTOCOL		= "INVALID_AUTHENTICATOR_PROTOCOL",
		JFC_IS_REQUIRED							= "JFC_IS_REQUIRED",
		LOGIN											= "LOGIN",
		LOGIN_CANCELLED							= "LOGIN_CANCELLED",
		LOGOUT										= "LOGOUT",
		LOGOUT_CANCELLED							= "LOGOUT_CANCELLED",
		MODIFY_TOKENS								= "MODIFY_TOKENS",
		MODIFY_TOKENS_CANCELLED					= "MODIFY_TOKENS_CANCELLED",
		NO_AUTHENTICATOR_CHANNEL_SERVICE		= "NO_AUTHENTICATOR_CHANNEL_SERVICE",
		NO_AUTHENTICATOR_PROTOCOL_SERVICE	= "NO_AUTHENTICATOR_PROTOCOL_SERVICE",
      NO_ASSOCIATED_SCOPE						= "NO_ASSOCIATED_SCOPE",
      NO_DEFAULT_IDENTITY_EXISTS				= "NO_DEFAULT_IDENTITY_EXISTS",
      NO_DEFAULT_SCOPE_EXISTS					= "NO_DEFAULT_SCOPE_EXISTS",
      NO_SCOPE_EXISTS							= "NO_SCOPE_EXISTS",
      PROPERTY_FILE								= "PROPERTY_FILE",
      PROTOCOL_PARSING							= "PROTOCOL_PARSING",
      SCOPE_PARSING								= "SCOPE_PARSING",
      SERVICE_AUTH_PLATFORM_UNSUPPORTED   = "SERVICE_AUTH_PLATFORM_UNSUPPORTED",
      SERVICE_AUTH_TOKENS_UNSUPPORTED     = "SERVICE_AUTH_TOKENS_UNSUPPORTED",
		TOKENS_HAVE_EXPIRED						= "TOKENS_HAVE_EXPIRED",
		TOKENS_HAVE_EXPIRED_WITH_GRACE		= "TOKENS_HAVE_EXPIRED_WITH_GRACE",
		VERIFY_TOKENS								= "VERIFY_TOKENS",
		VERIFY_TOKENS_CANCELLED					= "VERIFY_TOKENS_CANCELLED";


	/**
	 * accessor to the object array
	 */
	public Object[][] getContents()
	{
		return contents;
	}

	/**
	 * list of objects which should be localized
	 */
	private final static Object[][] contents =
	{
		{ALREADY_AUTHENTICATED,					"Identity already authenticated to resource."},
		{ANOTHER_IDENTITY_IS_AUTHENTICATED,	"Another identity is authenticated to resource."},
		{AUTHENTICATOR,							"General Authenticator exception."},
		{AUTHENTICATOR_CHANNEL,					"General AuthenticatorChannel exception."},
		{AUTHENTICATOR_PROTOCOL,				"General AuthenticatorProtocol exception."},
      {CONFIGURATION,							"General Authenticator configuration error."},
      {CHANNEL_PARSING,							"Error parsing channels."},
		{CREATE_TOKENS,							"Attempt to create tokens failed."},
		{CREATE_TOKENS_CANCELLED,				"Attempt to create tokens cancelled by user."},
		{GET_IDENTITIES,							"Attempt to get authenticated identities failed."},
      {IDENTITY_PARSING,						"Error parsing identities."},
		{INVALID_AUTHENTICATOR_CHANNEL,		"Invalid authentication channel."},
		{INVALID_AUTHENTICATOR_PROTOCOL,		"Invalid authentication protocol."},
		{JFC_IS_REQUIRED,							"JFC 1.0 or better is required."},
		{LOGIN,										"Login failed."},
		{LOGIN_CANCELLED,							"Login cancelled by user."},
		{LOGOUT,										"Logout failed."},
		{LOGOUT_CANCELLED,						"Logout cancelled by user."},
		{MODIFY_TOKENS,							"Attempt to modify tokens failed."},
		{MODIFY_TOKENS_CANCELLED,				"Attempt to modify tokens cancelled by user."},
		{NO_AUTHENTICATOR_CHANNEL_SERVICE,	"No authentication channel service exists."},
		{NO_AUTHENTICATOR_PROTOCOL_SERVICE,	"No authentication protocol service exists."},
      {NO_ASSOCIATED_SCOPE,					"No associated scope exists for identity."},
      {NO_DEFAULT_IDENTITY_EXISTS,			"No default identity exists."},
      {NO_DEFAULT_SCOPE_EXISTS,				"No default identity scope exists."},
      {NO_SCOPE_EXISTS,							"No identity scope exists."},
      {PROPERTY_FILE,							"Error occurred opening the Authenticator's property configuration file."},
      {PROTOCOL_PARSING,						"Error parsing protocols."},
      {SCOPE_PARSING,							"Error parsing identity scopes."},
		{TOKENS_HAVE_EXPIRED,					"Tokens have expired."},
		{TOKENS_HAVE_EXPIRED_WITH_GRACE,		"Tokens have expired with a grace period."},
		{VERIFY_TOKENS,							"Attempt to verify tokens failed."},
		{VERIFY_TOKENS_CANCELLED,				"Attempt to verify tokens cancelled by user."}
	};
}
