/* **************************************************************************

  $Archive: /njcl/src/com/novell/java/util/VectorEnumerator.java $
  $Revision: 2 $
  $Modtime: 4/08/98 11:02a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.java.util;

import java.util.NoSuchElementException;
import java.util.Enumeration;
import java.util.Vector;
import java.io.Serializable;

/** @internal
 *
 */
public final class VectorEnumerator implements Enumeration, Serializable
{
   private int size, current;
   private Vector vector;

   public VectorEnumerator (
      Vector vector)
   {
      current = 0;

      synchronized (vector) 
      {
         size = vector.size ();
         this.vector = (Vector) vector.clone ();
      }

   } /* VectorEnumerator () */

   /**
    *
    * @see java.util.Enumeration#hasMoreElements
    */
   public boolean hasMoreElements ()
   {
      return (current < size);
   }

   /**
    *
    * @see java.util.Enumeration#nextElement
    */
   public Object nextElement ()
   {
      if (current < size)
      {
         return (vector.elementAt (current++));
      }
      throw (new NoSuchElementException ());
   }

} /* VectorEnumerator */


