/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/bindery/BinderyInitialContextFactory.java $
  $Revision: 6 $
  $Modtime: 2/16/99 8:38a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.bindery;

import java.util.*;
import javax.naming.*;
import javax.naming.spi.*;
import com.sun.jndi.toolkit.*;

import com.novell.service.session.*;
import com.novell.utility.naming.*;

/**@internal
 * This is an implementation class which is used to create an InitialContext
 * for the Bindery name system. In order to be successful, a server (e.g.
 * host) must be specified in the provider URL, or the environment passed
 * must have a session and session manager. If neither of these cases are true
 * then the Bindery name system cannot create an InitialContext.
 *
 * @see BinderyDirContext
 */

public class BinderyInitialContextFactory implements InitialContextFactory
{
   /**
    * This is the public, default constructor required of an initial context
    * factory.
    */
   public BinderyInitialContextFactory ()
   {
   } // BinderyInitialContextFactory ()

   /**
    * Creates an Initial Context for beginning name resolution.
    * Optional properties that specify special requirements of this
    * context are supplied using 'info'.  An example of such properties
    * could be user identity information.
    *
    * @param hash                Hashtable containing information to be used
    *                            in the creation of the initial context.  Can
    *                            be null according to specification, but will
    *                            fail in the Bindery provider.
    * @return                    An initial context object that implements
    *                            the Context interface.
    */
   public Context getInitialContext (
         Hashtable hash)
      throws NamingException
   {
      if (null == hash)
      {
         throw new NullPointerException ("hash");
      }

      BinderyEnvironment environment = new BinderyEnvironment (hash);

      try
      {
         SessionManager sm = environment.getSessionManager ();
         
         if (null == sm)
         {
            SessionEnv env = new SessionEnv ();
            env.put (SessionEnv.INITIAL_SESSION_FACTORY,
               "com.novell.service.session.nds.NDSInitialSessionFactory:" +
               "com.novell.service.session.bindery.BinderyInitialSessionFactory");
            sm = SessionManagerFactory.getSessionManager (env);
            environment.addToEnvironment (Environment.SESSION_MANAGER_OBJECT, sm);
         }
         
         Session session = environment.getSession ();
         if (null == session)
         {
            String url = environment.getProviderURL ();
            String serverName = new URLParser (url).getHost ();
            session = sm.getSessionTop (serverName);
            environment.addToEnvironment (Environment.SESSION_OBJECT, session);
         }
         // If we still have no session then we're broken so bail out
         if (null == session)
            throw new NoInitialContextException (Context.PROVIDER_URL);
      }
      catch (SessionException e)
      {
         NamingException ne = new NamingException ();
         ne.setRootCause (e);
      }
         
      return (new BinderyDirContext (environment));
   } // getInitialContext ()

} // class BinderyInitialContextFactory
