/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/bindery/BinderySchemaClassDefsContext.java $
  $Revision: 8 $
  $Modtime: 10/18/99 11:51a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.bindery;


import javax.naming.*;

import com.novell.utility.naming.directory.StaticSchemaContext;


/**@internal
 * Schema class def root for the bindery system.
 *
 * <p>This is the root schema DirContext that is returned from all bindery
 * contexts getSchemaClassDefinitions methods.
 * </p>
 */

public class BinderySchemaClassDefsContext extends StaticSchemaContext
{
   /* ***********************************************************************
    * These arrays are parallel and are used to construct the
    * childNameClassPairs and childBindings. Each array must contain an
    * entry for each child and each array must be the same length.
    * Consequently, if you add or delete a subordinate, you must add a 
    * subordinate in each of the following three arrays:
    *   childNames = The string (name) used by lookup
    *   childClasses = The class name placed in the NameClassPair
    *   childObjects = The object placed in the Binding
    ************************************************************************/

   protected static String binderyChildNames[] =
   {
      "Bindery Object"
   };

   protected static String binderyChildClasses[] =
   {
      "com.novell.service.bindery.BinderyObjectClassDefContext"
   };

   protected static Object binderyChildObjects[] =
   {
      new BinderyObjectClassDefContext ()
   };

   /**
    * This constructor sets the static schema class and object arrays
    */
   public BinderySchemaClassDefsContext ()
   {
      super ("Classes");

      initBindingsAndPairs (
         binderyChildNames,
         binderyChildClasses,
         binderyChildObjects);

   }

} /* class BinderySchemaClassDefsContext */


