/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/file/nw/TrusteePathEnumerator.java $
  $Revision: 7 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.file.nw;

import java.util.Enumeration;
import com.novell.service.jncp.NSIException;
import com.novell.service.rfc1960.SearchStringComponent;

/** 
 * Provides information about trustee paths.
 *
 * <p>This class contains the following information about the trustee
 * paths:
 * <ul>
 * <li>User - The users name for which to return trustee paths.
 * <li>Paths - The paths for the currently logged or requested user.
 * </ul> </p>
 *
 * <p>jndi.ds.Attribute.getAttributeID() returns "Trustee Paths"
 * as the attribute ID for this interface. This attribute returns
 * all paths on a volume that a user is assigned to as a trustee.
 *
 * <p>Warning:  This class results in a mutable object. For versatility, 
 * code block synchronization has been implemented in the various jndi search 
 * and modify methods of this class's implementation to provide for thread 
 * safe operation.
 * 
 * <p>If you have a multi-threaded application and a code segment of that
 * application uses get methods of this class, and there is a potential 
 * of another thread randomly using corresponding set methods of this class,
 * you should enclose the calls to the get methods of this class in a 
 * synchronized code block.
 * </p>
 * <p>If you have a multi-threaded application and a code segment of that
 * application uses set method of this class, and there is a potential 
 * of another thread randomly using corresponding get methods of this class,
 * you should enclose the calls to the set methods of this class in a 
 * synchronized code block.
 * </p>
 * <p>This object has a dual mode of operation. The first mode is when
 * the average user wants to know what their trustee paths are on a given 
 * directory entry. The second mode is requesting the trustee paths of 
 * some other user on the system. This mode of operation is enabled by
 * the user setting the user name of the object, and it requires that
 * the logged user have managerial rights (in the bindery) over the
 * user name being requested. 
 * </p>
 */

public interface TrusteePathEnumerator extends Enumeration
{
/* *************************************************************************
* constants
***************************************************************************/

   /**
    * Attribute ID of the TrusteePathEnumerator.
    *
    * <p>(ATTRIBUTE_ID = "Trustee Paths")
    * </p>
    */
   public static final String ATTRIBUTE_ID = "Trustee Paths";

   /**
    * Schema Class Definition Name of the TrusteePathEnumerator.
    *
    * <p>(SCHEMA_BINDING_NAME = ATTRIBUTE_ID + " Definition")
    * </p>
    */
   public static final String SCHEMA_BINDING_NAME =
         ATTRIBUTE_ID + " Definition";

   /**
    * Schema Syntax of the TrusteePathEnumerator.
    *
    * <p>(COMPARE_SYNTAX_STRING = 
    *       "(" +
    *       SearchStringComponent.EQUALS_STRING + "," +
    *       SearchStringComponent.PRESENT_STRING + "," +
    *       SearchStringComponent.SUBSTRING_STRING + 
    *       ")")
    * </p>
    */
   public static final String COMPARE_SYNTAX_STRING =
         new String(
               "(" +
               SearchStringComponent.EQUALS_STRING + "," +
               SearchStringComponent.PRESENT_STRING +
               ")");

/* *************************************************************************
* public abstract methods
***************************************************************************/

   /**
    * Returns one path for this object.
    *
    * <p>The getPath() method is used only to set up an attribute value
    * for searches.
    */
   public String getPath();

   /**
    * Set one path for this object based on the input parameter.
    *
    * <p>The setPath() method is used only to set up an attribute
    * value for searches.
    * 
    * @param path The path to set for the object.
    */
   public void setPath(String path);

   /**
    * Returns the name of this objects User associated with the trustee
    * paths.
    *
    * @return The name of the User.
    */
   public String getUser();

   /**
    * Set the name of this objects user associated with the trustee
    * paths.
    *
    * <p>Calling the setUser() method on an object returned from a jndi
    * getAttributes call will result in obtaining of the trustee paths
    * for the user that is set.</p>
    *
    * @param user The user for which to obtain the trustee paths.
    */
   public void setUser(String user) throws NSIException;

   /**
    * Returns the next path value, typed as a String.
    *
    * @return A string containing the next path in the enumeration.
    *
    * @exception NoSuchElementException if there is no next element
    *            in the enumeration.
    */
   public String next() throws NSIException;

   /**
    * Returns a boolean indicating whether the enumeration
    * contains more elements.
    *
    * @return A boolean set to TRUE if there are more elements to
    *         be returned; otherwise FALSE is returned.
    */
   public boolean hasMore() throws NSIException;
}