/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/file/nw/VolumeInformation.java $
  $Revision: 10 $
  $Modtime: 3/07/00 4:34p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.file.nw;

import com.novell.service.rfc1960.SearchStringComponent;
import com.novell.service.rfc1960.Rfc1960Parser;

/** 
 * Provides for attribute values of volume information associated with
 * a given Volume.
 * 
 * <p>This class results in a mutable object. For versitility, code block
 * synchronization has been implemented in the various jndi search and
 * modify methods of this classes implementation to provide for thread 
 * safe operation.</p>
 *
 * <p>If you have a code segment of a multi-threaded application  that
 * uses get methods of this class, and there is a potential of another
 * thread randomly using corresponding set methods of this class, you
 * should enclose the calls to the get methods of this class in a 
 * synchronized code block.</p>
 *
 * <p>If you have a code segment of a multi-threaded application  that
 * uses set methods of this class, and there is a potential of another
 * thread randomly using corresponding get methods of this class, you
 * should enclose the calls to the set methods of this class in a 
 * synchronized code block.</p>
 */
 
public class VolumeInformation implements Cloneable
{
/* **************************************************************************
   jndi naming interface defines
****************************************************************************/

   /**
    * Attribute ID of VolumeInformation.
    *
    * <p>(ATTRIBUTE_ID = "Volume Information")
    * </p>
    */

   public static final String ATTRIBUTE_ID = "Volume Information";

   /**
    * Schema Name of VolumeInformation.
    *
    * <p>(SCHEMA_BINDING_NAME = ATTRIBUTE_ID + " Definition")
    * </p>
    */

   public static final String SCHEMA_BINDING_NAME = 
         ATTRIBUTE_ID + " Definition";

   /**
    * Schema Syntax of VolumeInformation.
    *
    * <p>(COMPARE_SYNTAX_STRING = 
    *       "(" +
    *       SearchStringComponent.EQUALS_STRING + "," +
    *       SearchStringComponent.PRESENT_STRING + "," +
    *       SearchStringComponent.SUBSTRING_STRING + 
    *       ")")
    * </p>
    */

   public static final String COMPARE_SYNTAX_STRING = 
         new String(
               "(" +
               SearchStringComponent.EQUALS_STRING + "," +
               SearchStringComponent.PRESENT_STRING + "," +
               SearchStringComponent.SUBSTRING_STRING + 
               ")");

/* **************************************************************************
   compareString field name defines
****************************************************************************/

   /**
    * The VolName compare field.
    *
    * <p>(VOLNAME_FIELD = "VolName")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String VOLNAME_FIELD = new String("VolName");

   /**
    * The TotalBlocks compare field.
    *
    * <p>(TOTALBLOCKS_FIELD = "TotalBlocks")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String TOTALBLOCKS_FIELD = new String("TotalBlocks");

   /**
    * The SectorsPerBlock compare field.
    *
    * <p>(SECTORSPERBLOCK_FIELD = "SectorsPerBlock")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String SECTORSPERBLOCK_FIELD = 
      new String("SectorsPerBlock");

   /**
    * The AvailableBlocks compare field.
    *
    * <p>(AVAILABLEBLOCKS_FIELD = "AvailableBlocks")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String AVAILABLEBLOCKS_FIELD = 
      new String("AvailableBlocks");

   /**
    * The TotalDirEntries compare field.
    *
    * <p>(TOTALDIRENTRIES_FIELD = "TotalDirEntries")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String TOTALDIRENTRIES_FIELD = 
      new String("TotalDirEntries");

   /**
    * The AvailableDirEntries compare field.
    *
    * <p>(AVAILABLEDIRENTRIES_FIELD = "AvailableDirEntries")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String AVAILABLEDIRENTRIES_FIELD = 
      new String("AvailableDirEntries");

   /**
    * The VolIsRemovableFlag compare field.
    *
    * <p>(VOLISREMOVABLEFLAG_FIELD = "VolIsRemovableFlag")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String VOLISREMOVABLEFLAG_FIELD = 
      new String("VolIsRemovableFlag");

   /**
    * The VolType compare field.
    *
    * <p>(VOLTYPE_FIELD = "VolType")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String VOLTYPE_FIELD = new String("VolType");

   /**
    * The StatusFlag compare field.
    *
    * <p>(STATUSFLAG_FIELD = "StatusFlag")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String STATUSFLAG_FIELD = new String("StatusFlag");

   /**
    * The SectorSize compare field.
    *
    * <p>(SECTORSIZE_FIELD = "SectorSize")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String SECTORSIZE_FIELD = new String("SectorSize");

   /**
    * The SectorsPerCluster compare field.
    *
    * <p>(SECTORSPERCLUSTER_FIELD = "SectorsPerCluster")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String SECTORSPERCLUSTER_FIELD = 
      new String("SectorsPerCluster");

   /**
    * The VolSizeInClusters compare field.
    *
    * <p>(VOLSIZEINCLUSTERS_FIELD = "VolSizeInClusters")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String VOLSIZEINCLUSTERS_FIELD = 
      new String("VolSizeInClusters");

   /**
    * The FreeClusters compare field.
    *
    * <p>(FREECLUSTERS_FIELD = "FreeClusters")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String FREECLUSTERS_FIELD = 
      new String("FreeClusters");

   /**
    * The SubAllocFreeableClusters compare field.
    *
    * <p>(SUBALLOCFREEABLECLUSTERS_FIELD = "SubAllocFreeableClusters")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String SUBALLOCFREEABLECLUSTERS_FIELD = 
      new String("SubAllocFreeableClusters");

   /**
    * The FreeableLimboSectors compare field.
    *
    * <p>(FREEABLELIMBOSECTORS_FIELD = "FreeableLimboSectors")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String FREEABLELIMBOSECTORS_FIELD = 
      new String("FreeableLimboSectors");

   /**
    * The NonfreeableLimboSectors compare field.
    *
    * <p>(NONFREEABLELIMBOSECTORS_FIELD = "NonfreeableLimboSectors")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String NONFREEABLELIMBOSECTORS_FIELD = 
      new String("NonfreeableLimboSectors");

   /**
    * The AvailSubAllocSectors compare field.
    *
    * <p>(AVAILSUBALLOCSECTORS_FIELD = "AvailSubAllocSectors")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String AVAILSUBALLOCSECTORS_FIELD = 
      new String("AvailSubAllocSectors");

   /**
    * The NonuseableSubAllocSectors compare field.
    *
    * <p>(NONUSEABLESUBALLOCSECTORS_FIELD = "NonuseableSubAllocSectors")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String NONUSEABLESUBALLOCSECTORS_FIELD = 
      new String("NonuseableSubAllocSectors");

   /**
    * The SubAllocClusters compare field.
    *
    * <p>(SUBALLOCCLUSTERS_FIELD = "SubAllocClusters")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String SUBALLOCCLUSTERS_FIELD = 
      new String("SubAllocClusters");

   /**
    * The NumDataStreams compare field.
    *
    * <p>(NUMDATASTREAMS_FIELD = "NumDataStreams")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String NUMDATASTREAMS_FIELD = 
      new String("NumDataStreams");

   /**
    * The NumLimboDataStreams compare field.
    *
    * <p>(NUMLIMBODATASTREAMS_FIELD = "NumLimboDataStreams")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String NUMLIMBODATASTREAMS_FIELD = 
      new String("NumLimboDataStreams");

   /**
    * The OldestDelFileAgeInTicks compare field.
    *
    * <p>(OLDESTDELFILEAGEINTICKS_FIELD = "OldestDelFileAgeInTicks")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String OLDESTDELFILEAGEINTICKS_FIELD = 
      new String("OldestDelFileAgeInTicks");

   /**
    * The NumCompressedDataStreams compare field.
    *
    * <p>(NUMCOMPRESSEDDATASTREAMS_FIELD = "NumCompressedDataStreams")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String NUMCOMPRESSEDDATASTREAMS_FIELD = 
      new String("NumCompressedDataStreams");

   /**
    * The NumCompressedLimboDataStreams compare field.
    *
    * <p>(NUMCOMPRESSEDLIMBODATASTREAMS_FIELD = "NumCompressedLimboDataStreams")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String NUMCOMPRESSEDLIMBODATASTREAMS_FIELD = 
      new String("NumCompressedLimboDataStreams");

   /**
    * The NumNoncompressibleDataStreams compare field.
    *
    * <p>(NUMNONCOMPRESSIBLEDATASTREAMS_FIELD = "NumNoncompressibleDataStreams")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String NUMNONCOMPRESSIBLEDATASTREAMS_FIELD = 
      new String("NumNoncompressibleDataStreams");

   /**
    * The PrecompressedSectors compare field.
    *
    * <p>(PRECOMPRESSEDSECTORS_FIELD = "PrecompressedSectors")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String PRECOMPRESSEDSECTORS_FIELD = 
      new String("PrecompressedSectors");

   /**
    * The CompressedSectors compare field.
    *
    * <p>(COMPRESSEDSECTORS_FIELD = "CompressedSectors")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String COMPRESSEDSECTORS_FIELD = 
      new String("CompressedSectors");

   /**
    * The NumMigratedDataStreams compare field.
    *
    * <p>(NUMMIGRATEDDATASTREAMS_FIELD = "NumMigratedDataStreams")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String NUMMIGRATEDDATASTREAMS_FIELD = 
      new String("NumMigratedDataStreams");

   /**
    * The MigratedSectors compare field.
    *
    * <p>(MIGRATEDSECTORS_FIELD = "MigratedSectors")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String MIGRATEDSECTORS_FIELD = 
      new String("MigratedSectors");

   /**
    * The ClustersUsedByFAT compare field.
    *
    * <p>(CLUSTERSUSEDBYFAT_FIELD = "ClustersUsedByFAT")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String CLUSTERSUSEDBYFAT_FIELD = 
      new String("ClustersUsedByFAT");

   /**
    * The ClustersUsedByDirs compare field.
    *
    * <p>(CLUSTERSUSEDBYDIRS_FIELD = "ClustersUsedByDirs")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String CLUSTERSUSEDBYDIRS_FIELD = 
      new String("ClustersUsedByDirs");

   /**
    * The ClustersUsedByExtDirs compare field.
    *
    * <p>(CLUSTERSUSEDBYEXTDIRS_FIELD = "ClustersUsedByExtDirs")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String CLUSTERSUSEDBYEXTDIRS_FIELD = 
      new String("ClustersUsedByExtDirs");

   /**
    * The UnusedDirEntries compare field.
    *
    * <p>(UNUSEDDIRENTRIES_FIELD = "UnusedDirEntries")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String UNUSEDDIRENTRIES_FIELD = 
      new String("UnusedDirEntries");

   /**
    * The TotalExtDirExtants compare field.
    *
    * <p>(TOTALEXTDIREXTANTS_FIELD = "TotalExtDirExtants")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String TOTALEXTDIREXTANTS_FIELD = 
      new String("TotalExtDirExtants");

   /**
    * The UnusedExtDirExtants compare field.
    *
    * <p>(UNUSEDEXTDIREXTANTS_FIELD = "UnusedExtDirExtants")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String UNUSEDEXTDIREXTANTS_FIELD = 
      new String("UnusedExtDirExtants");

   /**
    * The ExtAttrsDefined compare field.
    *
    * <p>(EXTATTRSDEFINED_FIELD = "ExtAttrsDefined")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String EXTATTRSDEFINED_FIELD = 
      new String("ExtAttrsDefined");

   /**
    * The ExtAttrExtantsUsed compare field.
    *
    * <p>(EXTATTREXTANTSUSED_FIELD = "ExtAttrExtantsUsed")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String EXTATTREXTANTSUSED_FIELD = 
      new String("ExtAttrExtantsUsed");

   /**
    * The DirectoryServicesName compare field.
    *
    * <p>(DIRECTORYSERVICESNAME_FIELD = "DirectoryServicesName")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String DIRECTORYSERVICESNAME_FIELD = 
      new String("DirectoryServicesName");

   /**
    * The VolLastModifiedDateAndTime compare field.
    *
    * <p>(VOLLASTMODIFIEDDATEANDTIME_FIELD = "VolLastModifiedDateAndTime")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String VOLLASTMODIFIEDDATEANDTIME_FIELD = 
      new String("VolLastModifiedDateAndTime");

   /**
    * The PurgeableBlocks compare field.
    *
    * <p>(PURGEABLEBLOCKS_FIELD = "PurgeableBlocks")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String PURGEABLEBLOCKS_FIELD = 
      new String("PurgeableBlocks");

   /**
    * The NotYetPurgeableBlocks compare field.
    *
    * <p>(NOTYETPURGEABLEBLOCKS_FIELD = "NotYetPurgeableBlocks")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String NOTYETPURGEABLEBLOCKS_FIELD = 
      new String("NotYetPurgeableBlocks");

   /**
    * The Reserved compare field.
    *
    * <p>(RESERVED_FIELD = "Reserved")
    * </p>
    * @see #setCompareString
    * @see #equals
    */

   public static final String RESERVED_FIELD = new String("Reserved");


/* **************************************************************************
   VolumeInformation state data members
****************************************************************************/

   // NWGetVolumeInfoWithNumber fields
   private String volName;
   private int totalBlocks;
   private int sectorsPerBlock;
   private int availableBlocks;
   private int totalDirEntries;
   private int availableDirEntries;
   private int volIsRemovableFlag;

   // NWGetExtendedVolumeInfo fields

   private int volType;
   private int statusFlag;
   private int sectorSize;
   private int sectorsPerCluster;
   private int volSizeInClusters;
   private int freeClusters;
   private int subAllocFreeableClusters;
   private int freeableLimboSectors;
   private int nonfreeableLimboSectors;
   private int availSubAllocSectors;
   private int nonuseableSubAllocSectors;
   private int subAllocClusters;
   private int numDataStreams;
   private int numLimboDataStreams;
   private int oldestDelFileAgeInTicks;
   private int numCompressedDataStreams;
   private int numCompressedLimboDataStreams;
   private int numNoncompressibleDataStreams;
   private int precompressedSectors;
   private int compressedSectors;
   private int numMigratedDataStreams;
   private int migratedSectors;
   private int clustersUsedByFAT;
   private int clustersUsedByDirs;
   private int clustersUsedByExtDirs;
// already avail. in other native call...   private int totalDirEntries;
   private int unusedDirEntries;
   private int totalExtDirExtants;
   private int unusedExtDirExtants;
   private int extAttrsDefined;
   private int extAttrExtantsUsed;
   private String directoryServicesName;
   private int volLastModifiedDateAndTime;

   // NWGetDirSpaceInfo fields
//   private int totalBlocks;
//   private int availableBlocks;
   private int purgeableBlocks;
   private int notYetPurgeableBlocks;
//   private int totalDirEntries;
//   private int availableDirEntries;
   private int reserved;
//   private int sectorsPerBlock;
//   private String volName;

   // only here for native to fill and convert to directoryServicesName
   protected int directoryServicesObjectId;

   private String compareString;
   private Rfc1960Parser ssParser = null;
   private boolean firstParser = true;

/* **************************************************************************
* Constructors
****************************************************************************/

   /**
    * Creates a Default VolumeInformation Constructor with no
    * parameters.
    */

   public VolumeInformation()
   {
   }
       
   /**
    * Creates a full VolumeInformation Constructor with all possible
    * parameters and initializes the object to the values of these
    * parameters.
    *
    * <p>The actual directoryServicesName parameter reference will be
    * stored by this object (it will not be cloned). Later modifications
    * to to this references state will be reflected in this object.</p>
    *
    * @param volName             The volName data members value.
    * @param totalBlocks         The totalBlocks data members value.
    * @param sectorsPerBlock     The sectorsPerBlock data members value.
    * @param availableBlocks     The availableBlocks data members value.
    * @param totalDirEntries     The totalDirEntries data members value.
    * @param availableDirEntries The availableDirEntries data members value.
    * @param volIsRemovableFlag  The volIsRemovableFlag data members value.
    * @param volType             The volType data members value.
    * @param statusFlag          The statusFlag data members value.
    * @param sectorSize          The sectorSize data members value.
    * @param sectorsPerCluster   The sectorsPerCluster data members value.
    * @param volSizeInClusters   The volSizeInClusters data members value.
    * @param freeClusters        The freeClusters data members value.
    * @param subAllocFreeableClusters  The subAllocFreeableClusters data 
    *                                  members value.
    * @param freeableLimboSectors      The freeableLimboSectors data 
    *                                  members value.
    * @param nonfreeableLimboSectors   The nonfreeableLimboSectors data 
    *                                  members value.
    * @param availSubAllocSectors      The availSubAllocSectors data 
    *                                  members value.
    * @param nonuseableSubAllocSectors The nonuseableSubAllocSectors data 
    *                                  members value.
    * @param subAllocClusters          The subAllocClusters data members value.
    * @param numDataStreams            The numDataStreams data members value.
    * @param numLimboDataStreams       The numLimboDataStreams data members value.
    * @param oldestDelFileAgeInTicks   The oldestDelFileAgeInTicks data 
    *                                  members value.
    * @param numCompressedDataStreams  The numCompressedDataStreams data 
    *                                  members value.
    * @param numCompressedLimboDataStreams The numCompressedLimboDataStreams 
    *                                      data members value.
    * @param numNoncompressibleDataStreams The numNoncompressibleDataStreams 
    *                                      data members value.
    * @param precompressedSectors          The precompressedSectors data 
    *                                      members value.
    * @param compressedSectors             The compressedSectors data members 
    *                                      value.
    * @param numMigratedDataStreams        The numMigratedDataStreams data 
    *                                      members value.
    * @param migratedSectors       The migratedSectors data members value.
    * @param clustersUsedByFAT     The clustersUsedByFAT data members value.
    * @param clustersUsedByDirs    The clustersUsedByDirs data members value.
    * @param clustersUsedByExtDirs The clustersUsedByExtDirs data 
    *                              members value.
    * @param unusedDirEntries      The unusedDirEntries data members value.
    * @param totalExtDirExtants    The totalExtDirExtants data members value.
    * @param unusedExtDirExtants   The unusedExtDirExtants data members value.
    * @param extAttrsDefined       The extAttrsDefined data members value.
    * @param extAttrExtantsUsed    The extAttrExtantsUsed data members value.
    * @param directoryServicesName The directoryServicesName data 
    *                              members value.
    * @param volLastModifiedDateAndTime The volLastModifiedDateAndTime data 
    *                                   members value.
    * @param purgeableBlocks       The purgeableBlocks data members value.
    * @param notYetPurgeableBlocks The notYetPurgeableBlocks data members value.
    * @param reserved              The reserved data members value.
    */

   public VolumeInformation(
      String volName,
      int totalBlocks,
      int sectorsPerBlock,
      int availableBlocks,
      int totalDirEntries,
      int availableDirEntries,
      boolean volIsRemovableFlag,
      int volType,
      int statusFlag,
      int sectorSize,
      int sectorsPerCluster,
      int volSizeInClusters,
      int freeClusters,
      int subAllocFreeableClusters,
      int freeableLimboSectors,
      int nonfreeableLimboSectors,
      int availSubAllocSectors,
      int nonuseableSubAllocSectors,
      int subAllocClusters,
      int numDataStreams,
      int numLimboDataStreams,
      int oldestDelFileAgeInTicks,
      int numCompressedDataStreams,
      int numCompressedLimboDataStreams,
      int numNoncompressibleDataStreams,
      int precompressedSectors,
      int compressedSectors,
      int numMigratedDataStreams,
      int migratedSectors,
      int clustersUsedByFAT,
      int clustersUsedByDirs,
      int clustersUsedByExtDirs,
      int unusedDirEntries,
      int totalExtDirExtants,
      int unusedExtDirExtants,
      int extAttrsDefined,
      int extAttrExtantsUsed,
      String directoryServicesName,
      int volLastModifiedDateAndTime,
      int purgeableBlocks,
      int notYetPurgeableBlocks,
      int reserved)
   {
      this.volName = volName;
      this.totalBlocks = totalBlocks;
      this.sectorsPerBlock = sectorsPerBlock;
      this.availableBlocks = availableBlocks;
      this.totalDirEntries = totalDirEntries;
      this.availableDirEntries = availableDirEntries;
      if (volIsRemovableFlag)
         this.volIsRemovableFlag = -1;
      else
         this.volIsRemovableFlag = 0;
      this.volType = volType;
      this.statusFlag = statusFlag;
      this.sectorSize = sectorSize;
      this.sectorsPerCluster = sectorsPerCluster;
      this.volSizeInClusters = volSizeInClusters;
      this.freeClusters = freeClusters;
      this.subAllocFreeableClusters = subAllocFreeableClusters;
      this.freeableLimboSectors = freeableLimboSectors;
      this.nonfreeableLimboSectors = nonfreeableLimboSectors;
      this.availSubAllocSectors = availSubAllocSectors;
      this.nonuseableSubAllocSectors = nonuseableSubAllocSectors;
      this.subAllocClusters = subAllocClusters;
      this.numDataStreams = numDataStreams;
      this.numLimboDataStreams = numLimboDataStreams;
      this.oldestDelFileAgeInTicks = oldestDelFileAgeInTicks;
      this.numCompressedDataStreams = numCompressedDataStreams;
      this.numCompressedLimboDataStreams = numCompressedLimboDataStreams;
      this.numNoncompressibleDataStreams = numNoncompressibleDataStreams;
      this.precompressedSectors = precompressedSectors;
      this.compressedSectors = compressedSectors;
      this.numMigratedDataStreams = numMigratedDataStreams;
      this.migratedSectors = migratedSectors;
      this.clustersUsedByFAT = clustersUsedByFAT;
      this.clustersUsedByDirs = clustersUsedByDirs;
      this.clustersUsedByExtDirs = clustersUsedByExtDirs;
      this.unusedDirEntries = unusedDirEntries;
      this.totalExtDirExtants = totalExtDirExtants;
      this.unusedExtDirExtants = unusedExtDirExtants;
      this.extAttrsDefined = extAttrsDefined;
      this.extAttrExtantsUsed = extAttrExtantsUsed;
      this.directoryServicesName = directoryServicesName;
      this.volLastModifiedDateAndTime = volLastModifiedDateAndTime;
      this.purgeableBlocks = purgeableBlocks;
      this.notYetPurgeableBlocks = notYetPurgeableBlocks;
      this.reserved = reserved;
   }

/* **************************************************************************
   Public Accessor methods
****************************************************************************/

   /**
    * Returns the volName field of this Object.
    *
    * @return The current volName value.
    */

   public String getVolName()
   {
      return(volName);
   }

   /**
    * Sets the volName field of this Object.
    *
    * @param value The new volName value.
    */

   public void setVolName(String value)
   {
      volName = value;
   }

   /**
    * Returns the totalBlocks field of this Object.
    *
    * @return The current totalBlocks value.
    */

   public int getTotalBlocks()
   {
      return(totalBlocks);
   }

   /**
    * Sets the totalBlocks field of this Object.
    *
    * @param value The new totalBlocks value.
    */

   public void setTotalBlocks(int value)
   {
      totalBlocks = value;
   }

   /**
    * Returns the sectorsPerBlock field of this Object.
    *
    * @return The current sectorsPerBlock value.
    */

   public int getSectorsPerBlock()
   {
      return(sectorsPerBlock);
   }

   /**
    * Sets the sectorsPerBlock field of this Object.
    *
    * @param value The new sectorsPerBlock value.
    */

   public void setSectorsPerBlock(int value)
   {
      sectorsPerBlock = value;
   }

   /**
    * Returns the availableBlocks field of this Object.
    *
    * @return The current availableBlocks value.
    */

   public int getAvailableBlocks()
   {
      return(availableBlocks);
   }

   /**
    * Sets the availableBlocks field of this Object.
    *
    * @param value The new availableBlocks value.
    */

   public void setAvailableBlocks(int value)
   {
      availableBlocks = value;
   }

   /**
    * Returns the totalDirEntries field of this Object.
    *
    * @return The current totalDirEntries value.
    */

   public int getTotalDirEntries()
   {
      return(totalDirEntries);
   }

   /**
    * Sets the totalDirEntries field of this Object.
    *
    * @param value The new totalDirEntries value.
    */

   public void setTotalDirEntries(int value)
   {
      totalDirEntries = value;
   }

   /**
    * Returns the availableDirEntries field of this Object.
    *
    * @return The current availableDirEntries value.
    */

   public int getAvailableDirEntries()
   {
      return(availableDirEntries);
   }

   /**
    * Sets the availableDirEntries field of this Object.
    *
    * @param value The new availableDirEntries value.
    */

   public void setAvailableDirEntries(int value)
   {
      availableDirEntries = value;
   }

   /**
    * Returns the volIsRemovableFlag field of this Object.
    *
    * @return The current volIsRemovableFlag value.
    */

   public boolean getVolIsRemovableFlag()
   {
      if (volIsRemovableFlag != 0)
         return true;
      return false;
   }

   /**
    * Sets the volIsRemovableFlag field of this Object.
    *
    * @param value The new volIsRemovableFlag value.
    */

   public void setVolIsRemovableFlag(boolean value)
   {
      if (!value)
         volIsRemovableFlag = 0;
      else
         volIsRemovableFlag = -1;
   }

   /**
    * Returns the volType field of this Object.
    *
    * @return The current volType value.
    */

   public int getVolType()
   {
      return(volType);
   }

   /**
    * Sets the volType field of this Object.
    *
    * @param value The new volType value.
    */

   public void setVolType(int value)
   {
      volType = value;
   }

   /**
    * Returns the statusFlag field of this Object.
    *
    * @return The current statusFlag value.
    */

   public int getStatusFlag()
   {
      return(statusFlag);
   }

   /**
    * Sets the statusFlag field of this Object.
    *
    * @param value The new statusFlag value.
    */

   public void setStatusFlag(int value)
   {
      statusFlag = value;
   }

   /**
    * Returns the sectorSize field of this Object.
    *
    * @return The current sectorSize value.
    */

   public int getSectorSize()
   {
      return(sectorSize);
   }

   /**
    * Sets the sectorSize field of this Object.
    *
    * @param value The new sectorSize value.
    */

   public void setSectorSize(int value)
   {
      sectorSize = value;
   }

   /**
    * Returns the sectorsPerCluster field of this Object.
    *
    * @return The current sectorsPerCluster value.
    */

   public int getSectorsPerCluster()
   {
      return(sectorsPerCluster);
   }

   /**
    * Sets the sectorsPerCluster field of this Object.
    *
    * @param value The new sectorsPerCluster value.
    */

   public void setSectorsPerCluster(int value)
   {
      sectorsPerCluster = value;
   }

   /**
    * Returns the volSizeInClusters field of this Object.
    *
    * @return The current volSizeInClusters value.
    */

   public int getVolSizeInClusters()
   {
      return(volSizeInClusters);
   }

   /**
    * Sets the volSizeInClusters field of this Object.
    *
    * @param value The new volSizeInClusters value.
    */

   public void setVolSizeInClusters(int value)
   {
      volSizeInClusters = value;
   }

   /**
    * Returns the freeClusters field of this Object.
    *
    * @return The current freeClusters value.
    */

   public int getFreeClusters()
   {
      return(freeClusters);
   }

   /**
    * Sets the freeClusters field of this Object.
    *
    * @param value The new freeClusters value.
    */

   public void setFreeClusters(int value)
   {
      freeClusters = value;
   }

   /**
    * Returns the subAllocFreeableClusters field of this Object.
    *
    * @return The current subAllocFreeableClusters value.
    */

   public int getSubAllocFreeableClusters()
   {
      return(subAllocFreeableClusters);
   }

   /**
    * Sets the subAllocFreeableClusters field of this Object.
    *
    * @param value The new subAllocFreeableClusters value.
    */

   public void setSubAllocFreeableClusters(int value)
   {
      subAllocFreeableClusters = value;
   }

   /**
    * Returns the freeableLimboSectors field of this Object.
    *
    * @return The current freeableLimboSectors value.
    */

   public int getFreeableLimboSectors()
   {
      return(freeableLimboSectors);
   }

   /**
    * Sets the freeableLimboSectors field of this Object.
    *
    * @param value The new freeableLimboSectors value.
    */

   public void setFreeableLimboSectors(int value)
   {
      freeableLimboSectors = value;
   }

   /**
    * Returns the nonfreeableLimboSectors field of this Object.
    *
    * @return The current nonfreeableLimboSectors value.
    */

   public int getNonfreeableLimboSectors()
   {
      return(nonfreeableLimboSectors);
   }

   /**
    * Sets the nonfreeableLimboSectors field of this Object.
    *
    * @param value The new nonfreeableLimboSectors value.
    */

   public void setNonfreeableLimboSectors(int value)
   {
      nonfreeableLimboSectors = value;
   }

   /**
    * Returns the availSubAllocSectors field of this Object.
    *
    * @return The current availSubAllocSectors value.
    */

   public int getAvailSubAllocSectors()
   {
      return(availSubAllocSectors);
   }

   /**
    * Sets the availSubAllocSectors field of this Object.
    *
    * @param value The new availSubAllocSectors value.
    */

   public void setAvailSubAllocSectors(int value)
   {
      availSubAllocSectors = value;
   }

   /**
    * Returns the nonuseableSubAllocSectors field of this Object.
    *
    * @return The current nonuseableSubAllocSectors value.
    */

   public int getNonuseableSubAllocSectors()
   {
      return(nonuseableSubAllocSectors);
   }

   /**
    * Sets the nonuseableSubAllocSectors field of this Object.
    *
    * @param value The new nonuseableSubAllocSectors value.
    */

   public void setNonuseableSubAllocSectors(int value)
   {
      nonuseableSubAllocSectors = value;
   }

   /**
    * Returns the subAllocClusters field of this Object.
    *
    * @return The current subAllocClusters value.
    */

   public int getSubAllocClusters()
   {
      return(subAllocClusters);
   }

   /**
    * Sets the subAllocClusters field of this Object.
    *
    * @param value The new subAllocClusters value.
    */

   public void setSubAllocClusters(int value)
   {
      subAllocClusters = value;
   }

   /**
    * Returns the numDataStreams field of this Object.
    *
    * @return The current numDataStreams value.
    */

   public int getNumDataStreams()
   {
      return(numDataStreams);
   }

   /**
    * Sets the numDataStreams field of this Object.
    *
    * @param value The new numDataStreams value.
    */

   public void setNumDataStreams(int value)
   {
      numDataStreams = value;
   }

   /**
    * Returns the numLimboDataStreams field of this Object.
    *
    * @return The current numLimboDataStreams value.
    */

   public int getNumLimboDataStreams()
   {
      return(numLimboDataStreams);
   }

   /**
    * Sets the numLimboDataStreams field of this Object.
    *
    * @param value The new numLimboDataStreams value.
    */

   public void setNumLimboDataStreams(int value)
   {
      numLimboDataStreams = value;
   }

   /**
    * Returns the oldestDelFileAgeInTicks field of this Object.
    *
    * @return The current oldestDelFileAgeInTicks value.
    */

   public int getOldestDelFileAgeInTicks()
   {
      return(oldestDelFileAgeInTicks);
   }

   /**
    * Sets the oldestDelFileAgeInTicks field of this Object.
    *
    * @param value The new oldestDelFileAgeInTicks value.
    */

   public void setOldestDelFileAgeInTicks(int value)
   {
      oldestDelFileAgeInTicks = value;
   }

   /**
    * Returns the numCompressedDataStreams field of this Object.
    *
    * @return The current numCompressedDataStreams value.
    */

   public int getNumCompressedDataStreams()
   {
      return(numCompressedDataStreams);
   }

   /**
    * Sets the numCompressedDataStreams field of this Object.
    *
    * @param value The new numCompressedDataStreams value.
    */

   public void setNumCompressedDataStreams(int value)
   {
      numCompressedDataStreams = value;
   }

   /**
    * Returns the numCompressedLimboDataStreams field of this Object.
    *
    * @return The current numCompressedLimboDataStreams value.
    */

   public int getNumCompressedLimboDataStreams()
   {
      return(numCompressedLimboDataStreams);
   }

   /**
    * Sets the numCompressedLimboDataStreams field of this Object.
    *
    * @param value The new numCompressedLimboDataStreams value.
    */

   public void setNumCompressedLimboDataStreams(int value)
   {
      numCompressedLimboDataStreams = value;
   }

   /**
    * Returns the numNoncompressibleDataStreams field of this Object.
    *
    * @return The current numNoncompressibleDataStreams value.
    */

   public int getNumNoncompressibleDataStreams()
   {
      return(numNoncompressibleDataStreams);
   }

   /**
    * Sets the numNoncompressibleDataStreams field of this Object.
    *
    * @param value The new numNoncompressibleDataStreams value.
    */

   public void setNumNoncompressibleDataStreams(int value)
   {
      numNoncompressibleDataStreams = value;
   }

   /**
    * Returns the precompressedSectors field of this Object.
    *
    * @return The current precompressedSectors value.
    */

   public int getPrecompressedSectors()
   {
      return(precompressedSectors);
   }

   /**
    * Sets the precompressedSectors field of this Object.
    *
    * @param value The new precompressedSectors value.
    */

   public void setPrecompressedSectors(int value)
   {
      precompressedSectors = value;
   }

   /**
    * Returns the compressedSectors field of this Object.
    *
    * @return The current compressedSectors value.
    */

   public int getCompressedSectors()
   {
      return(compressedSectors);
   }

   /**
    * Sets the compressedSectors field of this Object.
    *
    * @param value The new compressedSectors value.
    */

   public void setCompressedSectors(int value)
   {
      compressedSectors = value;
   }

   /**
    * Returns the numMigratedDataStreams field of this Object.
    *
    * @return The current numMigratedDataStreams value.
    */

   public int getNumMigratedDataStreams()
   {
      return(numMigratedDataStreams);
   }

   /**
    * Sets the numMigratedDataStreams field of this Object.
    *
    * @param value The new numMigratedDataStreams value.
    */

   public void setNumMigratedDataStreams(int value)
   {
      numMigratedDataStreams = value;
   }

   /**
    * Returns the migratedSectors field of this Object.
    *
    * @return The current migratedSectors value.
    */

   public int getMigratedSectors()
   {
      return(migratedSectors);
   }

   /**
    * Sets the migratedSectors field of this Object.
    *
    * @param value The new migratedSectors value.
    */

   public void setMigratedSectors(int value)
   {
      migratedSectors = value;
   }

   /**
    * Returns the clustersUsedByFAT field of this Object.
    *
    * @return The current clustersUsedByFAT value.
    */

   public int getClustersUsedByFAT()
   {
      return(clustersUsedByFAT);
   }

   /**
    * Sets the clustersUsedByFAT field of this Object.
    *
    * @param value The new clustersUsedByFAT value.
    */

   public void setClustersUsedByFAT(int value)
   {
      clustersUsedByFAT = value;
   }

   /**
    * Returns the clustersUsedByDirs field of this Object.
    *
    * @return The current clustersUsedByDirs value.
    */

   public int getClustersUsedByDirs()
   {
      return(clustersUsedByDirs);
   }

   /**
    * Sets the clustersUsedByDirs field of this Object.
    *
    * @param value The new clustersUsedByDirs value.
    */

   public void setClustersUsedByDirs(int value)
   {
      clustersUsedByDirs = value;
   }

   /**
    * Returns the clustersUsedByExtDirs field of this Object.
    *
    * @return The current clustersUsedByExtDirs value.
    */

   public int getClustersUsedByExtDirs()
   {
      return(clustersUsedByExtDirs);
   }

   /**
    * Sets the clustersUsedByExtDirs field of this Object.
    *
    * @param value The new clustersUsedByExtDirs value.
    */

   public void setClustersUsedByExtDirs(int value)
   {
      clustersUsedByExtDirs = value;
   }

   /**
    * Returns the unusedDirEntries field of this Object.
    *
    * @return The current unusedDirEntries value.
    */

   public int getUnusedDirEntries()
   {
      return(unusedDirEntries);
   }

   /**
    * Sets the unusedDirEntries field of this Object.
    *
    * @param value The new unusedDirEntries value.
    */

   public void setUnusedDirEntries(int value)
   {
      unusedDirEntries = value;
   }

   /**
    * Returns the totalExtDirExtants field of this Object.
    *
    * @return The current totalExtDirExtants value.
    */

   public int getTotalExtDirExtants()
   {
      return(totalExtDirExtants);
   }

   /**
    * Sets the totalExtDirExtants field of this Object.
    *
    * @param value The new totalExtDirExtants value.
    */

   public void setTotalExtDirExtants(int value)
   {
      totalExtDirExtants = value;
   }

   /**
    * Returns the unusedExtDirExtants field of this Object.
    *
    * @return The current unusedExtDirExtants value.
    */

   public int getUnusedExtDirExtants()
   {
      return(unusedExtDirExtants);
   }

   /**
    * Sets the unusedExtDirExtants field of this Object.
    *
    * @param value The new unusedExtDirExtants value.
    */

   public void setUnusedExtDirExtants(int value)
   {
      unusedExtDirExtants = value;
   }

   /**
    * Returns the extAttrsDefined field of this Object.
    *
    * @return The current extAttrsDefined value.
    */

   public int getExtAttrsDefined()
   {
      return(extAttrsDefined);
   }

   /**
    * Sets the extAttrsDefined field of this Object.
    *
    * @param value The new extAttrsDefined value.
    */

   public void setExtAttrsDefined(int value)
   {
      extAttrsDefined = value;
   }

   /**
    * Returns the extAttrExtantsUsed field of this Object.
    *
    * @return The current extAttrExtantsUsed value.
    */

   public int getExtAttrExtantsUsed()
   {
      return(extAttrExtantsUsed);
   }

   /**
    * Sets the extAttrExtantsUsed field of this Object.
    *
    * @param value The new extAttrExtantsUsed value.
    */

   public void setExtAttrExtantsUsed(int value)
   {
      extAttrExtantsUsed = value;
   }

   /**
    * Returns a reference to this object's directoryServicesName 
    * field. If you modify the state of the returned object, it will be 
    * reflected in this object!
    *
    * @return The current directoryServicesName value.
    */

   public String getDirectoryServicesName()
   {
      return (directoryServicesName);
   }

   /**
    * Sets the directoryServicesName field of the Attribute.
    * The actual parameter reference will be stored by this object
    * (it will not be cloned). Later modifications to to this
    * references state will be reflected in this object.
    *
    * @param value The new directoryServicesName value.
    */

   public void setDirectoryServicesName(String value)
   {
      directoryServicesName = value;
   }

   /**
    * Returns the volLastModifiedDateAndTime field of this Object.
    *
    * @return The current volLastModifiedDateAndTime value.
    */

   public int getVolLastModifiedDateAndTime()
   {
      return(volLastModifiedDateAndTime);
   }

   /**
    * Sets the volLastModifiedDateAndTime field of this Object.
    *
    * @param value The new volLastModifiedDateAndTime value.
    */

   public void setVolLastModifiedDateAndTime(int value)
   {
      volLastModifiedDateAndTime = value;
   }

   /**
    * Returns the purgeableBlocks field of this Object.
    *
    * @return The current purgeableBlocks value.
    */

   public int getPurgeableBlocks()
   {
      return(purgeableBlocks);
   }

   /**
    * Sets the purgeableBlocks field of this Object.
    *
    * @param value The new purgeableBlocks value.
    */

   public void setPurgeableBlocks(int value)
   {
      purgeableBlocks = value;
   }

   /**
    * Returns the notYetPurgeableBlocks field of this Object.
    *
    * @return The current notYetPurgeableBlocks value.
    */

   public int getNotYetPurgeableBlocks()
   {
      return(notYetPurgeableBlocks);
   }

   /**
    * Sets the notYetPurgeableBlocks field of this Object.
    *
    * @param value The new notYetPurgeableBlocks value.
    */

   public void setNotYetPurgeableBlocks(int value)
   {
      notYetPurgeableBlocks = value;
   }

   /**
    * Returns the reserved field of this Object.
    *
    * @return The current reserved value.
    */

   public int getReserved()
   {
      return(reserved);
   }

   /**
    * Sets the reserved field of this Object.
    *
    * @param value The new reserved value.
    */

   public void setReserved(int value)
   {
      reserved = value;
   }

/* **************************************************************************
 public compareString support methods
****************************************************************************/

   /**
    * Set the compare string value for the compare fields.
    * 
    * <p>The compare string uses the RFC1960 (LDAP) search string
    * format and is used to allow individual compares on the compare
    * fields. See the list of compare fields in the full constructor
    * parameter list. If the string passed in is not a valid RFC1960
    * formated string, this method will throw an IllegalArgumentException.
    * If the compareString value is NULL, RFC1960 formatted compares
    * will be disabled.
    *
    * <p>The names of these fields takes the names of their 
    * corresponding methods minus the get or set prefix. Given the
    * following string:
    *
    * <p><i>   "(&(Name=*printer*)(ObjectId>=2)(Rights>=128))"</i>
    *
    * <p>The equals method will return TRUE if the name contains the
    * substring printer, the objectId is not 2, and the rights are set
    * to be able to modify (TA_MODIFY). If the approximate operator type
    * is used on the Rights field the various bits of the operand value
    * are checked, and if any of them are set, equals will return TRUE.
    * For example: "(Rights~=3) returns TRUE if either the TA_READ or
    * TA_WRITE bits are set, regardless of what other bits might be set.</p>
    *
    * @param compareString The RFC1960 formatted search string. NULL 
    *                      disables this compare functionality.
    *
    * @exception IllegalArgumentException if the string passed
    *            in is not a valid RFC1960 formatted string.
    *
    * @see #equals
    * @see #VOLNAME_FIELD
    * @see #TOTALBLOCKS_FIELD
    * @see #SECTORSPERBLOCK_FIELD
    * @see #AVAILABLEBLOCKS_FIELD
    * @see #TOTALDIRENTRIES_FIELD
    * @see #AVAILABLEDIRENTRIES_FIELD
    * @see #VOLISREMOVABLEFLAG_FIELD
    * @see #VOLTYPE_FIELD
    * @see #STATUSFLAG_FIELD
    * @see #SECTORSIZE_FIELD
    * @see #SECTORSPERCLUSTER_FIELD
    * @see #VOLSIZEINCLUSTERS_FIELD
    * @see #FREECLUSTERS_FIELD
    * @see #SUBALLOCFREEABLECLUSTERS_FIELD
    * @see #FREEABLELIMBOSECTORS_FIELD
    * @see #NONFREEABLELIMBOSECTORS_FIELD
    * @see #AVAILSUBALLOCSECTORS_FIELD
    * @see #NONUSEABLESUBALLOCSECTORS_FIELD
    * @see #SUBALLOCCLUSTERS_FIELD
    * @see #NUMDATASTREAMS_FIELD
    * @see #NUMLIMBODATASTREAMS_FIELD
    * @see #OLDESTDELFILEAGEINTICKS_FIELD
    * @see #NUMCOMPRESSEDDATASTREAMS_FIELD
    * @see #NUMCOMPRESSEDLIMBODATASTREAMS_FIELD
    * @see #NUMNONCOMPRESSIBLEDATASTREAMS_FIELD
    * @see #PRECOMPRESSEDSECTORS_FIELD
    * @see #COMPRESSEDSECTORS_FIELD
    * @see #NUMMIGRATEDDATASTREAMS_FIELD
    * @see #MIGRATEDSECTORS_FIELD
    * @see #CLUSTERSUSEDBYFAT_FIELD
    * @see #CLUSTERSUSEDBYDIRS_FIELD
    * @see #CLUSTERSUSEDBYEXTDIRS_FIELD
    * @see #UNUSEDDIRENTRIES_FIELD
    * @see #TOTALEXTDIREXTANTS_FIELD
    * @see #UNUSEDEXTDIREXTANTS_FIELD
    * @see #EXTATTRSDEFINED_FIELD
    * @see #EXTATTREXTANTSUSED_FIELD
    * @see #DIRECTORYSERVICESNAME_FIELD
    * @see #VOLLASTMODIFIEDDATEANDTIME_FIELD
    * @see #PURGEABLEBLOCKS_FIELD
    * @see #NOTYETPURGEABLEBLOCKS_FIELD
    * @see #RESERVED_FIELD
    */
    
   public void setCompareString(String compareString)
   {
      firstParser = true;
      if (compareString != null)
      {
         this.compareString = new String(compareString);
         ssParser = new Rfc1960Parser(compareString);
      }else
      {
         this.compareString = null;
         ssParser = null;
      }
   }

   /**
    * Returns the current value of compareString.
    *
    * @return The current value of compareString.
    *
    * @see #setCompareString
    */
    
   public String getCompareString()
   {
      return compareString;
   }


   /**
    * Returns a Rfc1960Parser object that was instantiated with the
    * compareString last set by the setCompareString method.
    *
    * @return The Rfc1960Parser object for the current compare String.
    *         NULL is returned if the compare string has not been set.
    */
    
   public Rfc1960Parser getSearchStringParser()
   {
      if (firstParser)
      {
         firstParser = false;
         return ssParser;
      }else
      {
         if (compareString == null)
            return null;
         return new Rfc1960Parser(compareString);
      }
   }

/* **************************************************************************
* overriden Object methods
****************************************************************************/

   /**
    * Compare the input object against this object for equality.
    * 
    * <p>If the input object has a RFC1960 compare string, this method
    * will do the comparision based on the commands in the compare string.
    * If the operationType is illegal for the data type being compared, an 
    * IllegalArmumentException will be thrown.
    * </p>
    *
    * @param obj The object to compare.
    * @return    A boolean set to TRUE if the objects are equal;
    *            otherwise FALSE is returned.
    *
    * @exception IllegalArgumentException if the operationType is
    *            illegal for the data type being compared.
    *
    * @see #setCompareString
    * @see #VOLNAME_FIELD
    * @see #TOTALBLOCKS_FIELD
    * @see #SECTORSPERBLOCK_FIELD
    * @see #AVAILABLEBLOCKS_FIELD
    * @see #TOTALDIRENTRIES_FIELD
    * @see #AVAILABLEDIRENTRIES_FIELD
    * @see #VOLISREMOVABLEFLAG_FIELD
    * @see #VOLTYPE_FIELD
    * @see #STATUSFLAG_FIELD
    * @see #SECTORSIZE_FIELD
    * @see #SECTORSPERCLUSTER_FIELD
    * @see #VOLSIZEINCLUSTERS_FIELD
    * @see #FREECLUSTERS_FIELD
    * @see #SUBALLOCFREEABLECLUSTERS_FIELD
    * @see #FREEABLELIMBOSECTORS_FIELD
    * @see #NONFREEABLELIMBOSECTORS_FIELD
    * @see #AVAILSUBALLOCSECTORS_FIELD
    * @see #NONUSEABLESUBALLOCSECTORS_FIELD
    * @see #SUBALLOCCLUSTERS_FIELD
    * @see #NUMDATASTREAMS_FIELD
    * @see #NUMLIMBODATASTREAMS_FIELD
    * @see #OLDESTDELFILEAGEINTICKS_FIELD
    * @see #NUMCOMPRESSEDDATASTREAMS_FIELD
    * @see #NUMCOMPRESSEDLIMBODATASTREAMS_FIELD
    * @see #NUMNONCOMPRESSIBLEDATASTREAMS_FIELD
    * @see #PRECOMPRESSEDSECTORS_FIELD
    * @see #COMPRESSEDSECTORS_FIELD
    * @see #NUMMIGRATEDDATASTREAMS_FIELD
    * @see #MIGRATEDSECTORS_FIELD
    * @see #CLUSTERSUSEDBYFAT_FIELD
    * @see #CLUSTERSUSEDBYDIRS_FIELD
    * @see #CLUSTERSUSEDBYEXTDIRS_FIELD
    * @see #UNUSEDDIRENTRIES_FIELD
    * @see #TOTALEXTDIREXTANTS_FIELD
    * @see #UNUSEDEXTDIREXTANTS_FIELD
    * @see #EXTATTRSDEFINED_FIELD
    * @see #EXTATTREXTANTSUSED_FIELD
    * @see #DIRECTORYSERVICESNAME_FIELD
    * @see #VOLLASTMODIFIEDDATEANDTIME_FIELD
    * @see #PURGEABLEBLOCKS_FIELD
    * @see #NOTYETPURGEABLEBLOCKS_FIELD
    * @see #RESERVED_FIELD
    */
    
   public boolean equals(Object obj)
   {
      if(obj == null || !(obj instanceof VolumeInformation))
         return false;
      VolumeInformation vi = (VolumeInformation)obj;

      Rfc1960Parser ssp = vi.getSearchStringParser();
      if (ssp == null)
      {
         // do a simple compare

         if (obj == this)
            return true;

         if (!SearchStringComponent.compareString(
            SearchStringComponent.EQUALS, volName, vi.getVolName(), true))
            return false;

         if (vi.getTotalBlocks() != totalBlocks)
            return false;

         if (vi.getSectorsPerBlock() != sectorsPerBlock)
            return false;

         if (vi.getAvailableBlocks() != availableBlocks)
            return false;

         if (vi.getTotalDirEntries() != totalDirEntries)
            return false;

         if (vi.getAvailableDirEntries() != availableDirEntries)
            return false;

         boolean bvalue = vi.getVolIsRemovableFlag();
         if (!bvalue && volIsRemovableFlag != 0)
            return false;

         if (bvalue && volIsRemovableFlag == 0)
            return false;

         if (vi.getVolType() != volType)
            return false;

         if (vi.getStatusFlag() != statusFlag)
            return false;

         if (vi.getSectorSize() != sectorSize)
            return false;

         if (vi.getSectorsPerCluster() != sectorsPerCluster)
            return false;

         if (vi.getVolSizeInClusters() != volSizeInClusters)
            return false;

         if (vi.getFreeClusters() != freeClusters)
            return false;

         if (vi.getSubAllocFreeableClusters() != subAllocFreeableClusters)
            return false;

         if (vi.getFreeableLimboSectors() != freeableLimboSectors)
            return false;

         if (vi.getNonfreeableLimboSectors() != nonfreeableLimboSectors)
            return false;

         if (vi.getAvailSubAllocSectors() != availSubAllocSectors)
            return false;

         if (vi.getNonuseableSubAllocSectors() != nonuseableSubAllocSectors)
            return false;

         if (vi.getSubAllocClusters() != subAllocClusters)
            return false;

         if (vi.getNumDataStreams() != numDataStreams)
            return false;

         if (vi.getNumLimboDataStreams() != numLimboDataStreams)
            return false;

         if (vi.getOldestDelFileAgeInTicks() != oldestDelFileAgeInTicks)
            return false;

         if (vi.getNumCompressedDataStreams() != numCompressedDataStreams)
            return false;

         if (vi.getNumCompressedLimboDataStreams() != 
             numCompressedLimboDataStreams)
            return false;

         if (vi.getNumNoncompressibleDataStreams() !=  
             numNoncompressibleDataStreams)
            return false;

         if (vi.getPrecompressedSectors() != precompressedSectors)
            return false;

         if (vi.getCompressedSectors() != compressedSectors)
            return false;

         if (vi.getNumMigratedDataStreams() != numMigratedDataStreams)
            return false;

         if (vi.getMigratedSectors() != migratedSectors)
            return false;

         if (vi.getClustersUsedByFAT() != clustersUsedByFAT)
            return false;

         if (vi.getClustersUsedByDirs() != clustersUsedByDirs)
            return false;

         if (vi.getClustersUsedByExtDirs() != clustersUsedByExtDirs)
            return false;

         if (vi.getUnusedDirEntries() != unusedDirEntries)
            return false;

         if (vi.getTotalExtDirExtants() != totalExtDirExtants)
            return false;

         if (vi.getUnusedExtDirExtants() != unusedExtDirExtants)
            return false;

         if (vi.getExtAttrsDefined() != extAttrsDefined)
            return false;

         if (vi.getExtAttrExtantsUsed() != extAttrExtantsUsed)
            return false;

         if (!SearchStringComponent.compareStringsEqual(vi.getDirectoryServicesName(), directoryServicesName))
            return false;

         if (vi.getVolLastModifiedDateAndTime() != 
             volLastModifiedDateAndTime)
            return false;

         if (vi.getPurgeableBlocks() != purgeableBlocks)
            return false;

         if (vi.getNotYetPurgeableBlocks() != notYetPurgeableBlocks)
            return false;

         if (vi.getReserved() != reserved)
            return false;

         return true;      
      }// if simple compare

      while (ssp.hasMoreElements())
      {
         SearchStringComponent ssc = ssp.next();
         String name = ssc.getAttributeId();
         boolean compared = false;

         if (name.equals(VOLNAME_FIELD))
         {
            compared =ssc.compareString(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getVolName() :
                                 ssc.getOperand(),
                              volName,
                                 true);
         }else
         {
         if (name.equals(TOTALBLOCKS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getTotalBlocks() :
                                 Integer.parseInt(ssc.getOperand()),
                              totalBlocks);
         }else
         {
         if (name.equals(SECTORSPERBLOCK_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getSectorsPerBlock() :
                                 Integer.parseInt(ssc.getOperand()),
                              sectorsPerBlock);
         }else
         {
         if (name.equals(AVAILABLEBLOCKS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getAvailableBlocks() :
                                 Integer.parseInt(ssc.getOperand()),
                              availableBlocks);
         }else
         {
         if (name.equals(TOTALDIRENTRIES_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getTotalDirEntries() :
                                 Integer.parseInt(ssc.getOperand()),
                              totalDirEntries);
         }else
         {
         if (name.equals(AVAILABLEDIRENTRIES_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getAvailableDirEntries() :
                                 Integer.parseInt(ssc.getOperand()),
                              availableDirEntries);
         }else
         {
         if (name.equals(VOLTYPE_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getVolType() :
                                 Integer.parseInt(ssc.getOperand()),
                              volType);
         }else
         {
         if (name.equals(STATUSFLAG_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getStatusFlag() :
                                 Integer.parseInt(ssc.getOperand()),
                              statusFlag);
         }else
         {
         if (name.equals(SECTORSIZE_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getSectorSize() :
                                 Integer.parseInt(ssc.getOperand()),
                              sectorSize);
         }else
         {
         if (name.equals(SECTORSPERCLUSTER_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getSectorsPerCluster() :
                                 Integer.parseInt(ssc.getOperand()),
                              sectorsPerCluster);
         }else
         {
         if (name.equals(VOLSIZEINCLUSTERS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getVolSizeInClusters() :
                                 Integer.parseInt(ssc.getOperand()),
                              volSizeInClusters);
         }else
         {
         if (name.equals(FREECLUSTERS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getFreeClusters() :
                                 Integer.parseInt(ssc.getOperand()),
                              freeClusters);
         }else
         {
         if (name.equals(SUBALLOCFREEABLECLUSTERS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getSubAllocFreeableClusters() :
                                 Integer.parseInt(ssc.getOperand()),
                              subAllocFreeableClusters);
         }else
         {
         if (name.equals(FREEABLELIMBOSECTORS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getFreeableLimboSectors() :
                                 Integer.parseInt(ssc.getOperand()),
                              freeableLimboSectors);
         }else
         {
         if (name.equals(NONFREEABLELIMBOSECTORS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getNonfreeableLimboSectors() :
                                 Integer.parseInt(ssc.getOperand()),
                              nonfreeableLimboSectors);
         }else
         {
         if (name.equals(AVAILSUBALLOCSECTORS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getAvailSubAllocSectors() :
                                 Integer.parseInt(ssc.getOperand()),
                              availSubAllocSectors);
         }else
         {
         if (name.equals(NONUSEABLESUBALLOCSECTORS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getNonuseableSubAllocSectors() :
                                 Integer.parseInt(ssc.getOperand()),
                              nonuseableSubAllocSectors);
         }else
         {
         if (name.equals(SUBALLOCCLUSTERS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getSubAllocClusters() :
                                 Integer.parseInt(ssc.getOperand()),
                              subAllocClusters);
         }else
         {
         if (name.equals(NUMDATASTREAMS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getNumDataStreams() :
                                 Integer.parseInt(ssc.getOperand()),
                              numDataStreams);
         }else
         {
         if (name.equals(NUMLIMBODATASTREAMS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getNumLimboDataStreams() :
                                 Integer.parseInt(ssc.getOperand()),
                              numLimboDataStreams);
         }else
         {
         if (name.equals(OLDESTDELFILEAGEINTICKS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getOldestDelFileAgeInTicks() :
                                 Integer.parseInt(ssc.getOperand()),
                              oldestDelFileAgeInTicks);
         }else
         {
         if (name.equals(NUMCOMPRESSEDDATASTREAMS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getNumCompressedDataStreams() :
                                 Integer.parseInt(ssc.getOperand()),
                              numCompressedDataStreams);
         }else
         {
         if (name.equals(NUMCOMPRESSEDLIMBODATASTREAMS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getNumCompressedLimboDataStreams() :
                                 Integer.parseInt(ssc.getOperand()),
                              numCompressedLimboDataStreams);
         }else
         {
         if (name.equals(NUMNONCOMPRESSIBLEDATASTREAMS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getNumNoncompressibleDataStreams() :
                                 Integer.parseInt(ssc.getOperand()),
                              numNoncompressibleDataStreams);
         }else
         {
         if (name.equals(PRECOMPRESSEDSECTORS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getPrecompressedSectors() :
                                 Integer.parseInt(ssc.getOperand()),
                              precompressedSectors);
         }else
         {
         if (name.equals(COMPRESSEDSECTORS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getCompressedSectors() :
                                 Integer.parseInt(ssc.getOperand()),
                              compressedSectors);
         }else
         {
         if (name.equals(NUMMIGRATEDDATASTREAMS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getNumMigratedDataStreams() :
                                 Integer.parseInt(ssc.getOperand()),
                              numMigratedDataStreams);
         }else
         {
         if (name.equals(MIGRATEDSECTORS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getMigratedSectors() :
                                 Integer.parseInt(ssc.getOperand()),
                              migratedSectors);
         }else
         {
         if (name.equals(CLUSTERSUSEDBYFAT_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getClustersUsedByFAT() :
                                 Integer.parseInt(ssc.getOperand()),
                              clustersUsedByFAT);
         }else
         {
         if (name.equals(CLUSTERSUSEDBYDIRS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getClustersUsedByDirs() :
                                 Integer.parseInt(ssc.getOperand()),
                              clustersUsedByDirs);
         }else
         {
         if (name.equals(CLUSTERSUSEDBYEXTDIRS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getClustersUsedByExtDirs() :
                                 Integer.parseInt(ssc.getOperand()),
                              clustersUsedByExtDirs);
         }else
         {
         if (name.equals(UNUSEDDIRENTRIES_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getUnusedDirEntries() :
                                 Integer.parseInt(ssc.getOperand()),
                              unusedDirEntries);
         }else
         {
         if (name.equals(TOTALEXTDIREXTANTS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getTotalExtDirExtants() :
                                 Integer.parseInt(ssc.getOperand()),
                              totalExtDirExtants);
         }else
         {
         if (name.equals(UNUSEDEXTDIREXTANTS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getUnusedExtDirExtants() :
                                 Integer.parseInt(ssc.getOperand()),
                              unusedExtDirExtants);
         }else
         {
         if (name.equals(EXTATTRSDEFINED_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getExtAttrsDefined() :
                                 Integer.parseInt(ssc.getOperand()),
                              extAttrsDefined);
         }else
         {
         if (name.equals(EXTATTREXTANTSUSED_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getExtAttrExtantsUsed() :
                                 Integer.parseInt(ssc.getOperand()),
                              extAttrExtantsUsed);
         }else
         {
         if (name.equals(VOLLASTMODIFIEDDATEANDTIME_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getVolLastModifiedDateAndTime() :
                                 Integer.parseInt(ssc.getOperand()),
                              volLastModifiedDateAndTime);
         }else
         {
         if (name.equals(PURGEABLEBLOCKS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getPurgeableBlocks() :
                                 Integer.parseInt(ssc.getOperand()),
                              purgeableBlocks);
         }else
         {
         if (name.equals(NOTYETPURGEABLEBLOCKS_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getNotYetPurgeableBlocks() :
                                 Integer.parseInt(ssc.getOperand()),
                              notYetPurgeableBlocks);
         }else
         {
         if (name.equals(RESERVED_FIELD))
         {
            compared = ssc.compareInt(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getReserved() :
                                 Integer.parseInt(ssc.getOperand()),
                              reserved);
         }else
         {
         if (name.equals(DIRECTORYSERVICESNAME_FIELD))
         {
            compared = ssc.compareString(
                              ssc.getOperationType(), 
                              ssc.operandReplacement() ?
                                 vi.getDirectoryServicesName() :
                                 ssc.getOperand(),
                              directoryServicesName,
                              true);
      }else
         {
         if (name.equals(VOLISREMOVABLEFLAG_FIELD))
         {
            if (ssc.operandReplacement())
               compared = ssc.compareBoolean(
                                 ssc.getOperationType(), 
                                 volIsRemovableFlag,
                                 vi.getVolIsRemovableFlag());
            else
               compared = ssc.compareBoolean(
                                 ssc.getOperationType(), 
                                 ssc.getOperand(),
                                 getVolIsRemovableFlag());
      }else
         compared = false;

         }}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}
         ssp.setCompareResult(ssc, compared);
      }
      return ssp.compared();
   }   

   /**
    * Returns a String representation of this object.
    *
    * <p>The returned string is in the following format: "volName: s,
    * totalBlocks: n, sectorsPerBlock: n, availableBlocks: n,
    * totalDirEntries: n, availableDirEntries: n, volIsRemovableFlag: n,
    * volType: n, statusFlag: n, sectorSize: n, sectorsPerCluster: n,
    * volSizeInClusters: n, freeClusters: n, subAllocFreeableClusters: n,
    * freeableLimboSectors: n, nonfreeableLimboSectors: n,
    * availSubAllocSectors: n, nonuseableSubAllocSectors: n,
    * subAllocClusters: n, numDataStreams: n, numLimboDataStreams: n,
    * oldestDelFileAgeInTicks: n, numCompressedDataStreams: n,
    * numCompressedLimboDataStreams: n, numNoncompressibleDataStreams: n,
    * precompressedSectors: n, compressedSectors: n,
    * numMigratedDataStreams: n, migratedSectors: n, clustersUsedByFAT: n,
    * clustersUsedByDirs: n, clustersUsedByExtDirs: n, unusedDirEntries: n,
    * totalExtDirExtants: n, unusedExtDirExtants: n, extAttrsDefined: n,
    * extAttrExtantsUsed: n, directoryServicesName: n,
    * volLastModifiedDateAndTime: n, purgeableBlocks: n,
    * notYetPurgeableBlocks: n, reserved: n, compareString: s"</p>
    *
    * @return A String representation of this object.
    */
    
   public String toString()
   {
      return new String(
                  "volName: " + volName +
                  ", totalBlocks: " + totalBlocks +
                  ", sectorsPerBlock: " + sectorsPerBlock +
                  ", availableBlocks: " + availableBlocks +
                  ", totalDirEntries: " + totalDirEntries +
                  ", availableDirEntries: " + availableDirEntries +
                  ", volIsRemovableFlag: " + volIsRemovableFlag +
                  ", volType: " + volType +
                  ", statusFlag: " + statusFlag +
                  ", sectorSize: " + sectorSize +
                  ", sectorsPerCluster: " + sectorsPerCluster +
                  ", volSizeInClusters: " + volSizeInClusters +
                  ", freeClusters: " + freeClusters +
                  ", subAllocFreeableClusters: " + subAllocFreeableClusters +
                  ", freeableLimboSectors: " + freeableLimboSectors +
                  ", nonfreeableLimboSectors: " + nonfreeableLimboSectors +
                  ", availSubAllocSectors: " + availSubAllocSectors +
                  ", nonuseableSubAllocSectors: " + 
                     nonuseableSubAllocSectors +
                  ", subAllocClusters: " + subAllocClusters +
                  ", numDataStreams: " + numDataStreams +
                  ", numLimboDataStreams: " + numLimboDataStreams +
                  ", oldestDelFileAgeInTicks: " + oldestDelFileAgeInTicks +
                  ", numCompressedDataStreams: " + numCompressedDataStreams +
                  ", numCompressedLimboDataStreams: " + 
                     numCompressedLimboDataStreams +
                  ", numNoncompressibleDataStreams: " + 
                     numNoncompressibleDataStreams +
                  ", precompressedSectors: " + precompressedSectors +
                  ", compressedSectors: " + compressedSectors +
                  ", numMigratedDataStreams: " + numMigratedDataStreams +
                  ", migratedSectors: " + migratedSectors +
                  ", clustersUsedByFAT: " + clustersUsedByFAT +
                  ", clustersUsedByDirs: " + clustersUsedByDirs +
                  ", clustersUsedByExtDirs: " + clustersUsedByExtDirs +
                  ", unusedDirEntries: " + unusedDirEntries +
                  ", totalExtDirExtants: " + totalExtDirExtants +
                  ", unusedExtDirExtants: " + unusedExtDirExtants +
                  ", extAttrsDefined: " + extAttrsDefined +
                  ", extAttrExtantsUsed: " + extAttrExtantsUsed +
                  ", directoryServicesName: " + directoryServicesName +
                  ", volLastModifiedDateAndTime: " + 
                  volLastModifiedDateAndTime +
                  ", purgeableBlocks: " + purgeableBlocks +
                  ", notYetPurgeableBlocks: " + notYetPurgeableBlocks +
                  ", reserved: " + reserved +
                  ", compareString: " + compareString);
   }

   /**
    * Instantiates a new VolumeInformation object with all new references,
    * but with the same values within those references.
    *
    * @return A new VolumeInformation object with the same values.
    */
    
   public Object clone()
   {
      VolumeInformation obj = null;
      try
      {
         obj = (VolumeInformation) super.clone();
      }
      catch (CloneNotSupportedException e)
      {
         // this shouldn't happen, since we are Cloneable
         throw (new InternalError());
      }

      obj.volName = volName;
      obj.totalBlocks = totalBlocks;
      obj.sectorsPerBlock = sectorsPerBlock;
      obj.availableBlocks = availableBlocks;
      obj.totalDirEntries = totalDirEntries;
      obj.availableDirEntries = availableDirEntries;
      obj.volIsRemovableFlag = volIsRemovableFlag;
      obj.volType = volType;
      obj.statusFlag = statusFlag;
      obj.sectorSize = sectorSize;
      obj.sectorsPerCluster = sectorsPerCluster;
      obj.volSizeInClusters = volSizeInClusters;
      obj.freeClusters = freeClusters;
      obj.subAllocFreeableClusters = subAllocFreeableClusters;
      obj.freeableLimboSectors = freeableLimboSectors;
      obj.nonfreeableLimboSectors = nonfreeableLimboSectors;
      obj.availSubAllocSectors = availSubAllocSectors;
      obj.nonuseableSubAllocSectors = nonuseableSubAllocSectors;
      obj.subAllocClusters = subAllocClusters;
      obj.numDataStreams = numDataStreams;
      obj.numLimboDataStreams = numLimboDataStreams;
      obj.oldestDelFileAgeInTicks = oldestDelFileAgeInTicks;
      obj.numCompressedDataStreams = numCompressedDataStreams;
      obj.numCompressedLimboDataStreams = numCompressedLimboDataStreams;
      obj.numNoncompressibleDataStreams = numNoncompressibleDataStreams;
      obj.precompressedSectors = precompressedSectors;
      obj.compressedSectors = compressedSectors;
      obj.numMigratedDataStreams = numMigratedDataStreams;
      obj.migratedSectors = migratedSectors;
      obj.clustersUsedByFAT = clustersUsedByFAT;
      obj.clustersUsedByDirs = clustersUsedByDirs;
      obj.clustersUsedByExtDirs = clustersUsedByExtDirs;
      obj.unusedDirEntries = unusedDirEntries;
      obj.totalExtDirExtants = totalExtDirExtants;
      obj.unusedExtDirExtants = unusedExtDirExtants;
      obj.extAttrsDefined = extAttrsDefined;
      obj.extAttrExtantsUsed = extAttrExtantsUsed;
      obj.directoryServicesName = directoryServicesName;
      obj.volLastModifiedDateAndTime = volLastModifiedDateAndTime;
      obj.purgeableBlocks = purgeableBlocks;
      obj.notYetPurgeableBlocks = notYetPurgeableBlocks;
      obj.reserved = reserved;
      obj.directoryServicesObjectId = directoryServicesObjectId;
      obj.compareString = compareString;
      obj.ssParser = ssParser;
      obj.firstParser = firstParser;
      obj.setCompareString(compareString);
      return obj;
   }
}