/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/file/nw/calls/ObjectName.java $
  $Revision: 6 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.file.nw.calls;

import com.novell.service.jncp.NSIException;

/** @internal
 * Novell object name support class
 * 
 * <p>This class provides Novell nds Object name and objectId support.  This
 * class simply supplies constructors that allow the name and objectId to be 
 * stored by the object and accessors to set and retrieve them.
 * </p>
 *
 */
 
public class ObjectName implements Cloneable
{
   private String name;   

/* **************************************************************************
* public constructors (published)
****************************************************************************/

   /**
    * Default constructor
    * 
    * <p>Construct this object.  The object name is currently unknown.  The 
    * getName method will return null until the setName method is called.
    * </p>
    */
    
   public ObjectName()
   {
      this.name = name;
   }

   /**
    * Full Constructor
    * 
    * <p>The name state will be set to the value of the parameter being
    * passed in.
    * </p>
    * @param name                object name
    */
    
   public ObjectName(String name)
   {
      this.name = name;
   }

   /**
    * Cloning constructor
    * 
    * <p>Takes a ObjectName object as the input parameter, setting all data
    * members to it's values.
    * </p>
    * @param ObjectName                objectName
    */
    
   public ObjectName(ObjectName objectName)
   {
      name = objectName.getName();
   }


/* **************************************************************************
* public accessors (published)
****************************************************************************/

   /**
    * Returns the Object Name
    * 
    * <p>Returns the object name which is the name handed into the 
    * constructor or set with the last call to the setName method.
    * </p>
    *
    * @return                    The Object name
    */
    
   public String getName()
   {
      return name;
   }

   /**
    * Sets the Object Name.
    * 
    * <p>Sets the Object Name
    * </p>
    *
    * @param name                The object name
    */
    
   public void setName(String name)
   {
      this.name = name;
   }

/* **************************************************************************
* public methods (overridden)
****************************************************************************/

   /**
    * Debug string
    * 
    * <p>Returns a String representation of this object in the following 
    * format: "name: s".
    * </p>
    *
    * @return                    String representation of this object
    */
    
   public String toString()
   {
      return new String("Name: " + name);
   }

   /**
    * clones this object
    * 
    * <p>Instantiates a new object of this type with the same name as this
    * object.
    * </p>
    *
    * @return                    A new ObjectName object with same value
    */
    
   public Object clone()
   {
      ObjectName obj = null;
      try
      {
         obj = (ObjectName) super.clone();
      }
      catch (CloneNotSupportedException e)
      {
         // this shouldn't happen, since we are Cloneable
         throw (new InternalError());
      }

      obj.name = name;
      return obj;
   }

   /**
    * Compare for equals
    * 
    * <p>This method compares the input object against this object.  If the 
    * value of equalsIgnoreCase for the two strings will be returned.
    * </p>
    *
    * @param obj                 The object to compare.
    * @return                    true if equals, false otherwise
    */

   public boolean equals(Object obj)
   {
      if (obj == this)
         return true;

      if (!(obj instanceof ObjectName))
         return false;

      ObjectName on = (ObjectName)obj;

      if (!on.getName().equalsIgnoreCase(name))
         return (false);
      
      return true;
   }
}   