/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/file/nw/naming/ReferenceEnumeration.java $
  $Revision: 1 $
  $Modtime: 3/03/98 10:57a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.file.nw.naming;

import java.util.Enumeration;
import java.util.NoSuchElementException;

import javax.naming.Reference;

/** @internal
 * This is the enumeration interface for enumerating References.  It
 * extends Enumeration to allow type-specific objects (in this
 * case 'Reference') to be returned.
 *
 * @see javax.naming.Reference
 */
public interface ReferenceEnumeration extends Enumeration
{
   /**
    * Retrieves the next reference in the enumeration.
    *
    * @return                    The next reference in the enumeration.
    */
   public Reference next () throws NoSuchElementException;
}
