/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/file/nw/naming/ReferencePage.java $
  $Revision: 1 $
  $Modtime: 3/03/98 10:57a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.file.nw.naming;

import java.io.InputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

import javax.naming.Reference;

/** @internal
 * Provides an interface for managing a set of named JNDI references.
 * Supports reading javax.naming.References from and writing them to streams.
 *
 * @see javax.naming.Reference
 */
public interface ReferencePage
{
   /**
    * Returns number of references in this reference page.
    *
    * @return                    Number of references in this ReferencePage.
    */
   public int size ();

   /**
    * Returns empty status of this reference page.
    *
    * @return                    true if this reference page is empty, false
    *                            if it is not.
    */
   public boolean isEmpty ();
   
   /**
    * Returns enumeration of the names of all references in this
    * reference page.
    *
    * @return                    StringEnumeration of names of all the
    *                            references.
    */
   public Enumeration names ();
   
   /**
    * Returns enumeration of the references in this reference page.
    *
    * @return                    ReferenceEnumeration of all references.
    */
   public ReferenceEnumeration references ();
   
   /**
    * Returns a reference given a name.
    *
    * <p>Returns null if there is no reference for the given name.
    * </p>
    *
    * @param      name           The name of the reference to return.
    * @return                    Reference corresponding to the name.
    */
   public Reference getReference (String name);
   
   /**
    * Puts a reference in this reference page.
    *
    * @param      name           The name of the new reference.
    * @param      reference      The reference to store.
    * @return                    If no reference exists under the given
    *                            name, null is returned.  If a reference
    *                            already exists under the given name,
    *                            it is returned, and the new
    *                            reference takes its place.
    */
   public Reference putReference (String name, Reference reference);
   
   /**
    * Removes a reference from this reference page.
    *
    * @param      name           name of the reference to be removed.
    * @return                    Removed reference.
    */
   public Reference removeReference (String name);

   /**
    * Reads references from an input stream.
    *
    * @param      src            The input stream from which to read
    *                            References.
    * @exception  IOException    When an error occurs reading the stream.
    * @exception  ClassNotFoundException When a class stored on the stream
    *                            is not found or loaded.
    */
   public void readFromSource (InputStream src) throws IOException, 
      ClassNotFoundException;
   
   /**
    * Sets the destination stream for storing all references from this
    * reference page on a stream.
    *
    * @param      dest           The output stream on which to store all
    *                            references in this reference page.
    */
   public void setDestination (OutputStream dest);
   
   /**
    * Stores all references on the previously determined output stream.
    *
    * <p>The output stream that is used to store the references is set
    * by calling the setDestination() method.
    * </p>
    *
    * @exception  IOException    When an error occurs writing to the stream.
    * @see #setDestination
    */
   public void flush () throws IOException;
}
