/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/jncpv2/clx/ClxJNI.java $
  $Revision: 32 $
  $Modtime: 3/20/03 5:54p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.jncpv2.clx;

import com.novell.java.lang.*;
import com.novell.service.security.NdsIdentity;
import com.novell.service.jncp.NSIException;
import com.novell.service.toolkit.jcl.*;
import com.novell.service.session.xplat.Address;
import com.novell.service.session.xplat.NDSContextInfo;
import java.util.Hashtable;

/**
 * Package class containing static native methods supporting operations
 * performed by the "client" package.
 */
public class ClxJNI
{
   /* Info Types */
   public static final int INFO_NONE_NUM             =  0;
   public static final int INFO_AUTHENT_STATE_NUM    =  1;
   public static final int INFO_BCAST_STATE_NUM      =  2;
   public static final int INFO_CONN_REF_NUM         =  3;
   public static final int INFO_TREE_NAME_NUM        =  4;
   public static final int INFO_CONN_NUMBER_NUM      =  5;
   public static final int INFO_USER_ID_NUM          =  6;
   public static final int INFO_SERVER_NAME_NUM      =  7;
   public static final int INFO_NDS_STATE_NUM        =  8;
   public static final int INFO_MAX_PACKET_SIZE_NUM  =  9;
   public static final int INFO_LICENSE_STATE_NUM    = 10;
   public static final int INFO_DISTANCE_NUM         = 11;
   public static final int INFO_SERVER_VERSION_NUM   = 12;

   /* Current Info Version */
   public static final int INFO_VERSION_NUM          = 0x0001;


   /**
    * Copies a hash entry from one Hashtable to another.
    *
    * <p>If hashKey does not exist in src, then hashKey/defaultValue is
    * copied to dest, if defaultValue is not null.
    * </p>
    *
    * @param <i>src</i>          (in) Hashtable to copy from (may be null).
    * @param <i>dest</i>         (in) Hashtable to copy to.
    * @param <i>hashKey</i>      (in) Key to copy.
    * @param <i>defaultValue</i> (in) Default value to copy if src does not
    *                            contain hashKey (may be null).
    *
    * @return                    true if the session is still valid.
    *                            Otherwise, false.
    *
    * @exception NSIException    Generic, source-unknown exception.
    */
   public static void copyHashEntry
   (
      Hashtable   src,
      Hashtable   dest,
      Object      hashKey,
      Object      defaultValue
   )
   {
      if (null != src)
      {
         if (src.containsKey(hashKey))
            dest.put(hashKey, src.get(hashKey));
         return;
      }
      if (null != defaultValue)
         dest.put(hashKey, defaultValue);
   }


   //
   // NWBinderySession
   //

   public static native int NWLoginToFileServer (
         /*in*/   int connHandle,
         /*in*/   String objectName,
         /*in*/   int objectType,
         /*in*/   String password);

   public static native int NWChangeObjectPassword (
         /*in*/   int connHandle,
         /*in*/   String objName,
         /*in*/   int objType,
         /*in*/   String oldPassword,
         /*in*/   String newPassword);

   public static native int NWVerifyObjectPassword (
         /*in*/   int connHandle,
         /*in*/   String objName,
         /*in*/   int objType,
         /*in*/   String password);

   public static native int NWLogoutFromFileServer (
         /*in*/   int connHandle);

   //
   // NWClient
   //

   public static native int NWCGetDefNameContext(StringBuffer context);

   public static native int NWCGetPrefServerName(StringBuffer name);

   public static native int NWCGetPrefDsTreeName(StringBuffer empty);

   public static native int NWCGetRequesterVersion(NWVersion version);

   public static native int NWGetNWNetVersion(NWVersion version);

   public static native int NWCGetSecurityFlags (
         /*out*/ IntegerBuffer enabledSecurity,     // optional
         /*out*/ IntegerBuffer preferredSecurity,   // optional
         /*out*/ IntegerBuffer requiredSecurity);   // optional

   public static native int NWCQueryFeature(int feature);

   public static native int NWCSetDefNameContext(String context);

   public static native int NWCSetPrefServerName(String name);

   public static native int NWCSetPrefDsTreeName(String name);

   public static native int NWCSetSecurityFlags (
         /*in*/ int preferredSecurity,
         /*in*/ int requiredSecurity);

   //
   // NWConnection
   //

   public static native int NWCGetConnInfoAddress (
         /*in*/   int connHandle,     // raw conn handle; if 0, we'll scan
         /*in*/   int connRef,
         /*out*/  Address addressToGet);

   public static native int NWCGetConnInfoLong (
         /*in*/   int connHandle,     // raw conn handle; if 0, we'll scan
         /*in*/   int connRef,
         /*in*/   int uInfoLevel,
         /*out*/  NWLong longToGet);

   public static native int NWCGetConnInfoString (
         /*in*/   int connHandle,     // raw conn handle; if 0, we'll scan
         /*in*/   int connRef,
         /*in*/   int uInfoLevel,
         /*out*/  StringBuffer strToGet);

   public static native int NWCGetConnInfoVersion (
         /*in*/   int connHandle,     // raw conn handle; if 0, we'll scan
         /*in*/   int connRef,
         /*in*/   int uInfoLevel,
         /*out*/  NWVersion versionToGet);

   public static native int NWCLicenseConn (int connHandle);

   public static native int NWCSpecialLicenseConn (int connHandle);

   public static native int NWCRenegotiateSecurityLevel (
         /*in*/   int connHandle,
         /*in*/   int luSecurityLevel);

   public static native int NWCSetConnInfoLong (
         /*in*/   int connHandle,
         /*in*/   int infoLevel,
         /*in*/   NWLong value);

   public static native int NWCUnlicenseConn (int connHandle);

   //
   // NWConnectionEnumerator
   //

   public static native int NWCScanConnInfoLong (
         /*in/out*/  NWLong pluScanIterator,
         /*in*/      int    uScanInfoLevel,
         /*in*/      NWLong pScanConnInfoLong,
         /*in*/      int    uScanFlags,
         /*out*/     NWLong pluConnectionReference); /* only output */

   public static native int NWCScanConnInfoString (
         /*in/out*/  NWLong pluScanIterator,
         /*in*/      int    uScanInfoLevel,
         /*in*/      String pScanConnInfoStr,
         /*in*/      int    uScanFlags,
         /*out*/     NWLong pluConnectionReference); /* only output */

   public static native int NWCScanConnInfoVersion (
         /*in/out*/  NWLong pluScanIterator,
         /*in*/      int    uScanInfoLevel,
         /*in*/      NWVersion pScanConnInfoVersion,
         /*in*/      int    uScanFlags,
         /*out*/     NWLong pluConnectionReference); /* only output */

   //
   // NWConnectionManager
   //

   public static native int NWCCloseConn (
         /*in*/ int connHandle);

   public static native int NWCSysCloseConnRef (
         /*in*/ int connRef);

   public static native int NWCGetNumConns (
         /*out*/  NWLong maxConnections,        // optional
         /*out*/  NWLong publicConnections,     // optional
         /*out*/  NWLong myPrivateConnections,  // optional
         /*out*/  NWLong otherPrivateConnections); // optional

   public static native int NWCGetPrimConnRef (
         /*in*/ NWLong connRef);

   public static native int NWCMakeConnPermanent (
         /*in*/ int connHandle);

   public static native int NWCOpenConnByAddress (
         /*in*/   int uConnFlags,
         /*in*/   Address address,
         /*out*/  NWLong connHandle);

   public static native int NWDSOpenConnToNDSServer (
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   String name,
         /*out*/  NWLong connHandle);

   public static native int NWCOpenConnByName (
         /*in*/   int startConnHandle,
         /*in*/   String name,
         /*in*/   int uNameFormatType,
         /*in*/   int uConnFlags,
         /*out*/  NWLong connHandle);

   public static native int NWCOpenConnByPref (
         /*in*/   int tranType,
         /*in*/   int connFlags,
         /*out*/  NWLong connHandle);

   public static native int NWCOpenConnDefault (
         /*out*/  NWLong defaultConnHandle);

   public static native int NWCOpenConnByReference (
         /*in*/   int luConnectionReference,
         /*in*/   int uConnFlags,
         /*out*/  NWLong connHandle);

   public static native int NWCGetInfoString (
         /*in*/   int connHandle,
         /*in*/   int uInfoLevel,
         /*out*/  StringBuffer strToGet);

   public static native int NWCSetPrimConn (int connHandle);
   
   public static native int NWCCFragmentRequest
   (
      int connHandle,
      int function,
      int verb,
      int reserved,
      byte[][] reqFrags,
      /*inout*/byte[][] replyFrags
   )throws NSIException;


   //
   // NDSSession
   //

   /**
    * Key names for NDSSession information.
    *
    * (DCK_FLAGS               =  1)
    * (DCK_CONFIDENCE          =  2)
    * (DCK_NAME_CONTEXT        =  3)
    * (DCK_TRANSPORT_TYPE      =  4)
    * (DCK_REFERRAL_SCOPE      =  5)
    * (DCK_LAST_CONNECTION     =  8)
    * (DCK_TREE_NAME           = 11)
    * </p>
    */
   public final static int  DCK_FLAGS               =  1;
   public final static int  DCK_CONFIDENCE          =  2;
   public final static int  DCK_NAME_CONTEXT        =  3;
   public final static int  DCK_TRANSPORT_TYPE      =  4;
   public final static int  DCK_REFERRAL_SCOPE      =  5;
   public final static int  DCK_LAST_CONNECTION     =  8;
   public final static int  DCK_TREE_NAME           = 11;
   public final static int  DCK_DSI_FLAGS           = 12;
   public final static int  DCK_NAME_FORM           = 13;
   public final static int  DCK_NAME_CACHE_DEPTH    = 15;
   /* NLM only--see NWDSIPXNetworkAddr */
   public final static int  DCK_LAST_SERVER_ADDRESS =  9;
   public final static int  DCK_LAST_ADDRESS_USED   = 10;

   /**
    * values for DCK_FLAGS key
    *
    * (DCV_DEREF_ALIASES        = 0x0001)
    * (DCV_XLATE_STRINGS        = 0x0002)
    * (DCV_TYPELESS_NAMES       = 0x0004)
    * (DCV_ASYNC_MODE           = 0x0008)
    * (DCV_CANONICALIZE_NAMES   = 0x0010)
    * (DCV_DEREF_BASE_CLASS     = 0x0040)
    * (DCV_DISALLOW_REFERRALS   = 0x0080)
    * </p>
    */
   public final static int  DCV_DEREF_ALIASES        = 0x0001;
   public final static int  DCV_XLATE_STRINGS        = 0x0002;
   public final static int  DCV_TYPELESS_NAMES       = 0x0004;
   public final static int  DCV_ASYNC_MODE           = 0x0008;
   public final static int  DCV_CANONICALIZE_NAMES   = 0x0010;
   public final static int  DCV_DEREF_BASE_CLASS     = 0x0040;
   public final static int  DCV_DISALLOW_REFERRALS   = 0x0080;

   /**
    * values for DCK_CONFIDENCE key
    *
    * (DCV_LOW_CONF             = 0)
    * (DCV_MED_CONF             = 1)
    * (DCV_HIGH_CONF            = 2)
    * </p>
    */
   public final static int  DCV_LOW_CONF             = 0;
   public final static int  DCV_MED_CONF             = 1;
   public final static int  DCV_HIGH_CONF            = 2;

   /**
    * values for DCK_REFERRAL_SCOPE key
    *
    * (DCV_ANY_SCOPE            = 0)
    * (DCV_COUNTRY_SCOPE        = 1)
    * (DCV_ORGANIZATION_SCOPE   = 2)
    * (DCV_LOCAL_SCOPE          = 3)
    * </p>
    */
   public final static int  DCV_ANY_SCOPE            = 0;
   public final static int  DCV_COUNTRY_SCOPE        = 1;
   public final static int  DCV_ORGANIZATION_SCOPE   = 2;
   public final static int  DCV_LOCAL_SCOPE          = 3;

   /* ERROR: directory services client library */
   public final static int  ERR_CONTEXT_CREATION     = 0xFFFFFEB8;


   /* *
    * NDSSession java wrappers.
    */

//   public static native int NWDSCreateContext();

   public static native int NWDSCreateContextHandle (
         /*out*/  int[] newThreadGroup,
         /*out*/  int[] newHandle);

   public static native int NWDSDuplicateContextHandle(
         /*in*/   int threadGroup,
         /*in*/   int srcContextHandle,
         /*out*/  int[] destContextHandle);

   public static native int NWDSFreeContext(
         /*in*/   int threadGroup,
         /*in*/   int context);

   public static native int NWDSLogin (
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int optionsFlag,
         /*in*/   String objectName,
         /*in*/   String password,
         /*in*/   int validityPeriod,
         /*in*/   boolean extendedCharPasswordFlag);

   public static native int NASLogin (
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   String objectName,
         /*in*/   String password,
         /*inout*/NdsIdentity ident,
         /*in*/   boolean extendedCharPasswordFlag);

   public static native int NWDSLoginAsService (
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int optionsFlag,
         /*in*/   String objectName,
         /*in*/   int validityPeriod);

   public static native int NWDSWhoami (
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*out*/  StringBuffer objectName);

   public static native int NWDSChangeObjectPassword (
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int optionsFlag,
         /*in*/   String objectName,
         /*in*/   String oldPassword,
         /*in*/   String newPassword,
         /*in*/   boolean extendedCharPasswordFlag);

   public static native int NWDSGetContext (
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int key,
         /*out*/  NDSContextInfo value);

   public static native int NWDSSetContext (
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int key,
         /*in*/   Object value);

   public static native int NWDSLogout(
         /*in*/   int threadGroup,
         /*in*/   int context);

   public static native int NASLogout(
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int nmasID);

   public static native int NWDSCanDSAuthenticate(
         /*in*/   int threadGroup,
         /*in*/   int context);

   public static native int NWDSSpecialIsDSAuthenticated(
         /*in*/   int threadGroup,
         /*in*/   int context);

   public static native int NWDSAuthenticateConn (
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int connHandle);

   public static native int NWDSGenerateObjectKeyPair(
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   String objectName,
         /*in*/   String password,
         /*in*/   int optionsFlag,
         /*in*/   boolean extendedCharPasswordFlag);

   public static native int NWDSVerifyObjectPassword(
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int optionsFlag,
         /*in*/   String objectName,
         /*in*/   String password,
         /*in*/   boolean extendedCharPasswordFlag);

   public static native int shutDownThreadGroup(
         /*in*/   int threadGroup);

   public static native int NWDSGetDSVerInfo(
         /*in*/   int connHandle,
         /*out*/  IntegerBuffer   rootMostEntryDepth,
         /*out*/  IntegerBuffer   dsVersion,
         /*out*/  IntegerBuffer   flags);

   public static native int NWDSGetServerDN (
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int connHandle,
         /*out*/  StringBuffer serverDN);
}
