/*
 * @(#)Finalizer.c	1.7 98/09/21
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 * 
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#include <jni.h>


#include "com_novell_service_jncpv2_misc_finalizerJNI.h"


/*
 * Class:     com_novell_service_jncpv2_misc_Finalizer
 * Method:    invokeFinalizeMethod
 * Signature: (Ljava/lang/Object;)V
 */
JNIEXPORT void JNICALL
Java_com_novell_service_jncpv2_misc_Finalizer_invokeFinalizeMethod
(
    JNIEnv *env,
    jclass unused,
    jobject object
)
{
    // JNI variables
    jclass cls;
    jmethodID mid;

    if (NULL != (cls = (*env)->GetObjectClass(env, object)))
    {
        if (NULL != (mid = (*env)->GetMethodID(env, cls, "finalize", "()V")))
        {
            (*env)->CallVoidMethod(env, object, mid);
        }
    }

} /* invokeFinalizeMethod() */
