
/****************************************************************************

  $Workfile: $
  $Revision: $
  $Modtime:: $
  $Copyright:

  Copyright (c) 1989-1995 Novell, Inc.  All Rights Reserved.                      

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE 
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.$

 ***************************************************************************/


#include <jni.h>
#include <sys_api.h>

#include "com_novell_service_jncpv2_misc_endianJNI.h"

#include <unicode.h>


/*
 * Class:     com_novell_service_jncpv2_misc_EndianInputStream
 * Method:    valueOf
 * Signature: ([B)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL
Java_com_novell_service_jncpv2_misc_EndianInputStream_getString
(
   JNIEnv *env,
   jclass cls,
   jbyteArray buffer,
   jint position
)
{
   jbyte *bytes;
   jchar *chars;
   jstring string;

   if (NULL == (bytes = (*env)->GetByteArrayElements (env, buffer, NULL)))
   {
      return (NULL);
   }

   chars = (jchar *)(bytes + position);

   string = (*env)->NewString (env, chars, unilen (chars));

   (*env)->ReleaseByteArrayElements (env, buffer, bytes, JNI_ABORT);

   return (string);

} /* getString () */


/*
 * Class:     com_novell_service_jncpv2_misc_EndianInputStream
 * Method:    readLoHiString
 * Signature: ()Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL 
Java_com_novell_service_jncpv2_misc_EndianInputStream_readLoHiString
(
   JNIEnv *env,
   jobject this
)
{
   // JNI variables
   jclass cls;
   jfieldID bufferId, positionId;
   jmethodID readLoHiIntMid;

   jbyteArray buffer;
   jint position, length;
   jbyte *region;
   jstring string;

   cls = (*env)->GetObjectClass (env, this);
   bufferId = (*env)->GetFieldID (env, cls, "buffer", "[B");
   positionId = (*env)->GetFieldID (env, cls, "position", "I");
   readLoHiIntMid = (*env)->GetMethodID (env, cls, "readLoHiInt", "()I");

   length = (*env)->CallIntMethod (env, this, readLoHiIntMid);

   buffer = (*env)->GetObjectField (env, this, bufferId);
   position = (*env)->GetIntField (env, this, positionId);
/*
   if ((position + length) > (*env)->GetArrayLength (env, buffer))
   {
      jclass clsEOFException;

      clsEOFException = (*env)->FindClass (env, "java/io/EOFException");
      (*env)->ThrowNew (env, clsEOFException, "");
      return (NULL);
   }
*/
   region = (jbyte *) sysMalloc (length);

   (*env)->GetByteArrayRegion (env, buffer, position, length, region);

   string = (*env)->NewString (env, (jchar *) region, length / 2);

   (*env)->SetIntField (env, this, positionId, position + length);

   sysFree (region);

   return (string);

} /* readLoHiString () */


