
/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#if !defined (NetEntryInfoJNI_H)
#define NetEntryInfoJNI_H


#if !defined (JNI_H)
#  include <jni.h>
#endif

#if !defined (NTYPES_H)
#  include <ntypes.h>
#endif

#if !defined (NWDSDC_H)
#  include <nwdsdc.h>
#endif

#if !defined (NWDSBUFT_H)
#  include <nwdsbuft.h>
#endif


#define NETPKG         "com/novell/service/jncpv2/net/"
#define JNCPPKG        "com/novell/service/jncp/"


/* public final class NetEntryInfo implements NdsObjectInfo, Serializable
 * {
 *    //
 *    private boolean dereference;
 *
 *    //
 *    private int outputFlags;
 *    private int entryId;
 *    private int entryFlags;
 *    private int subordinateCount;
 *    private int modificationTime;
 *    private int modificationTimestamp;
 *    private int creationTimestamp;
 *    private int partitionRootId;
 *    private int parentId;
 *    private int revisionCount;
 *    private int replicaType;
 *    private String baseClass;
 *    private String entryRDN;
 *    private String entryDN;
 *    private String partitionRootDN;
 *    private String parentDN;
 *    private int purgeTime;
 *    private String dereferenceBaseClass;
 *    private int replicaNumber;
 *    private int replicaState;
 *    private String federationBoundary;
 *    private String schemaBoundary;
 * }
 */

typedef struct tagNetEntryInfo
{
   jclass cls;

   struct
   {
      //
      jfieldID dereference;

      //
      jfieldID outputFlags;
      jfieldID entryId;
      jfieldID entryFlags;
      jfieldID subordinateCount;
      jfieldID modificationTime;
      jfieldID modificationTimestamp;
      jfieldID creationTimestamp;
      jfieldID partitionRootId;
      jfieldID parentId;
      jfieldID revisionCount;
      jfieldID replicaType;
      jfieldID baseClass;
      jfieldID entryRDN;
      jfieldID entryDN;
      jfieldID partitionRootDN;
      jfieldID parentDN;
      jfieldID purgeTime;
      jfieldID dereferenceBaseClass;
      jfieldID replicaNumber;
      jfieldID replicaState;
      jfieldID federationBoundary;
      jfieldID schemaBoundary;
   } ID;

} NetEntryInfo, N_FAR *pNetEntryInfo;


N_EXTERN_FUNC_C (pNetEntryInfo)
NetEntryInfoCreateStruct
(
   JNIEnv *env
);

N_EXTERN_FUNC_C (jobject)
NetEntryInfoCreate
(
   JNIEnv *env,
   pNetEntryInfo sNetEntryInfo,
   pBuf_T buf
);

N_EXTERN_FUNC_C (jobject)
NetEntryInfoCreateFromMemory
(
   JNIEnv *env,
   pNetEntryInfo sNetEntryInfo,
   pnstr8 buf,
   nuint32 length
);

#endif /* NetEntryInfoJNI_H */


