
/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/


#include <sys_api.h>

#include <stdlib.h>

#include <jni.h>

#include "com_novell_service_jncpv2_net_NetEntryInfoEnumerator.h"

#include <ntypes.h>
#include "JNIString.h"
#include <nwnet.h>



#include "NetEntryInfoJNI.h"
#include "NetAttributeValueFactoryJNI.h"

#include "jdsEntryList.h"


#ifdef __cplusplus
extern "C" {
#endif


/***** com_novell_service_jncpv2_net_NetJNI.h ****************************/

/*
 * Class:     com_novell_service_jncpv2_net_NetJNI
 * Method:    JDSAddFilterToken
 * Signature: (II[BI)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2_net_NetJNI_JDSAddFilterToken
(
   JNIEnv *env,
   jclass unused,
   /*in*/   jint           cursor,
   /*in*/   jint           token,
   /*in*/   jbyteArray     value,
   /*in*/   jint           syntaxId
)
{
   // JNI variables
   // NWNet variables
   NWDSCCODE ccode;
   nptr cValue = NULL;

   if (FTOK_AVAL == token)
   {
      cValue = NetAttributeValueFactory_toCStruct (env, value, syntaxId);
   }
   else if (FTOK_ANAME == token)
   {
      cValue = NetAttributeValueFactory_toCStruct (env, value, -1);
   }

   ccode = NWDSAddFilterToken (
              (pFilter_Cursor_T) cursor,
                       (nuint16) token,
                                 cValue,
                                 syntaxId);

   return (ccode);

} /* JDSAddFilterToken () */

#ifdef __cplusplus
}
#endif


