
/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/


#include <sys_api.h>

#include <jni.h>

#include <ntypes.h>

#include "JNIString.h"

#include <nwdsdefs.h>
#include <nwdsdc.h>
#include <nwdsbuft.h>
#include <nwdsdsa.h>

#ifdef N_PLAT_NLM
#  include "jncp.h"
#  include "nlmsem.h"
#endif


#include "jncpWire.h"
#include "jdsEntryList.h"

#include "com_novell_service_jncpv2_net_NetJNI.h"


#define NETPKG         "com/novell/service/jncpv2/net/"
#define JNCPPKG        "com/novell/service/jncp/"


/***** com_novell_service_jncpv2_net_NetJNI.h ****************************/

/*
 * Class:     com_novell_service_jncpv2_net_NetJNI
 * Method:    JDSReadObjectEntry
 * Signature: (IIILjava/lang/String;I[Lcom/novell/service/jncpv2/net/NetEntryInfo;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2_net_NetJNI_JDSReadObjectEntry
(
   JNIEnv *env,
   jclass unused,
   /*in*/   jint           threadGroup,
   /*in*/   jint           context,
   /*in*/   jint           sNetEntryInfo,
   /*in*/   jstring        object,
   /*in*/   jint           bufferSize,
   /*out*/  jobjectArray   entry
)
{
   // JNI variables
   // NWNet variables
   NWDSCCODE ccode;
   unicode cObject[MAX_DN_CHARS + 1];
   nptr  cObjectInfo, lockedcObjectInfo;
   nuint32 oldFlags, newFlags;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (N_SUCCESS != ccode)
   {
      goto EXIT;
   }
#endif

   // put the java unicode string into c unicode style.
   jstring2unicode (env, object, cObject, sizeof(cObject));

   // objectInfo.getHandle ()
   cObjectInfo = (nptr) sysMalloc (bufferSize);;

#ifdef N_PLAT_NLM
   if(_usingAliasFunctions)
   {
       // makeAndLockAlias
       lockedcObjectInfo = (*_aliasFunctions[0])(cObjectInfo, (size_t) bufferSize);
   }
   else
#endif
      lockedcObjectInfo = cObjectInfo;

   ccode = NWDSGetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &oldFlags);
   if (N_SUCCESS != ccode)
   {
      goto CLEANUP;
   }

   newFlags = 0x0033FFFF; // get all of DSIInfo

   ccode = NWDSSetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &newFlags);
   if (N_SUCCESS != ccode)
   {
      goto CLEANUP;
   }

   // Make C API call
   ccode = NWDSReadObjectDSIInfo (
                (NWDSContextHandle) context,
                           (pnstr8) cObject,
                                    bufferSize,
                                    lockedcObjectInfo);

   // set context back to what it was when we came in
   NWDSSetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &oldFlags);

   if (N_SUCCESS == ccode)
   {
      (*env)->SetObjectArrayElement (
                                       env,
                                       entry,
                                       0,
//                                       list->GetObjects (list));
                                       NetEntryInfoCreateFromMemory (
									                                    env, 
																		(pNetEntryInfo) sNetEntryInfo,
																		lockedcObjectInfo,
																		bufferSize)
                                       );
   }

CLEANUP:

#ifdef N_PLAT_NLM
   if (_usingAliasFunctions)
      (*_aliasFunctions[1])(lockedcObjectInfo, (size_t) bufferSize);
#endif
   sysFree (cObjectInfo);

#ifdef N_PLAT_NLM
   unwrapContext (saveThreadGroup);

EXIT:
#endif

   return (ccode);

} /* JDSReadObjectEntry () */


