/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

//#include "com_novell_service_nds_net_NetBoolean.h"

#include "jncpWire.h"

#include "NetBooleanJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetBoolean
 *    extends NdsBoolean
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected boolean value;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetBoolean)
NetBooleanCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetBoolean;
   jclass clsNetBooleanLR;
   //NJCL variables
   pNetBoolean sNetBoolean;

   clsNetBooleanLR = (*env)->FindClass (env, NETSYNTAXPKG "NetBoolean");
   clsNetBoolean = (*env)->NewGlobalRef (env, clsNetBooleanLR);
   (*env)->DeleteLocalRef (env, clsNetBooleanLR);

   sNetBoolean = (pNetBoolean) sysMalloc (sizeof (NetBoolean));

   if (NULL != sNetBoolean)
   {
      // assign jclass variables
      sNetBoolean->cls = clsNetBoolean;

      // assign jfieldID variables
      sNetBoolean->ID.value = (*env)->GetFieldID (env, clsNetBoolean, "value", "Z");
   }
   return (sNetBoolean);

} /* NetBooleanCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetBooleanCreate
(
   JNIEnv *env,
   pNetBoolean sNetBoolean,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netBoolean = (*env)->AllocObject (env, sNetBoolean->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      (*env)->SetBooleanField (
                                 env,
                                 netBoolean,
                                 sNetBoolean->ID.value,
                      (jboolean) jncpGetInt8 (env, curPos, limit));
   }

   return (netBoolean);

} /* NetBooleanCreate () */


#ifdef __cplusplus
}
#endif


