/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include "jncpWire.h"

#include "NetCaseExactStringJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetCaseExactString
 *    extends NdsCaseExactString
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetCaseExactString)
NetCaseExactStringCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetCaseExactString;
   jclass clsNetCaseExactStringLR;
   //NJCL variables
   pNetCaseExactString sNetCaseExactString;

   clsNetCaseExactStringLR = (*env)->FindClass (env, NETSYNTAXPKG "NetCaseExactString");
   clsNetCaseExactString = (*env)->NewGlobalRef (env, clsNetCaseExactStringLR);
   (*env)->DeleteLocalRef (env, clsNetCaseExactStringLR);

   sNetCaseExactString = (pNetCaseExactString) sysMalloc (sizeof (NetCaseExactString));

   if (NULL != sNetCaseExactString)
   {
      // assign jclass variables
      sNetCaseExactString->cls = clsNetCaseExactString;

      // assign jfieldID variables
      sNetCaseExactString->ID.value = (*env)->GetFieldID (env, clsNetCaseExactString, "value", "Ljava/lang/String;");
   }
   return (sNetCaseExactString);

} /* NetCaseExactStringCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetCaseExactStringCreate
(
   JNIEnv *env,
   pNetCaseExactString sNetCaseExactString,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netCaseExactString = (*env)->AllocObject (env, sNetCaseExactString->cls);

   {
      jstring value;

      NAlign32 (curPos);
      (*env)->SetObjectField (
                                 env,
                                 netCaseExactString,
                                 sNetCaseExactString->ID.value,
                        (jobject)(value = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, value);
   }

   return (netCaseExactString);

} /* NetCaseExactStringCreate () */


#ifdef __cplusplus
}
#endif


