/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include <unicode.h>

#include "jncpWire.h"

#include "NetCaseIgnoreListJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetCaseIgnoreList
 *    extends NdsCaseIgnoreList
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetCaseIgnoreList)
NetCaseIgnoreListCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsString;
   jclass clsNetCaseIgnoreList;
   //NJCL variables
   pNetCaseIgnoreList sNetCaseIgnoreList;

   {
      jclass clsNetCaseIgnoreListLR;

      clsNetCaseIgnoreListLR = (*env)->FindClass (env, NETSYNTAXPKG "NetCaseIgnoreList");
      clsNetCaseIgnoreList = (*env)->NewGlobalRef (env, clsNetCaseIgnoreListLR);
      (*env)->DeleteLocalRef (env, clsNetCaseIgnoreListLR);
   }

   {
      jclass clsStringLR;

      clsStringLR = (*env)->FindClass (env, "java/lang/String");
      clsString = (*env)->NewGlobalRef (env, clsStringLR);
      (*env)->DeleteLocalRef (env, clsStringLR);
   }

   sNetCaseIgnoreList = (pNetCaseIgnoreList) sysMalloc (sizeof (NetCaseIgnoreList));

   if (NULL != sNetCaseIgnoreList)
   {
      // assign jclass variables
      sNetCaseIgnoreList->cls = clsNetCaseIgnoreList;
      sNetCaseIgnoreList->clsString = clsString;

      // assign jfieldID variables
      sNetCaseIgnoreList->ID.values = (*env)->GetFieldID (env, clsNetCaseIgnoreList, "values", "[Ljava/lang/String;");
   }
   return (sNetCaseIgnoreList);

} /* NetCaseIgnoreListCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetCaseIgnoreListCreate
(
   JNIEnv *env,
   pNetCaseIgnoreList sNetCaseIgnoreList,
   pBuf_T buf
)
{
   // JNI variables
   jobjectArray values;
   // NWNet variables
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netCaseIgnoreList = (*env)->AllocObject (env, sNetCaseIgnoreList->cls);

   {
      // NWNet variables
      nuint32 i, length, count;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);

      count = jncpGetInt32 (env, curPos, limit);

      values = (*env)->NewObjectArray (env, count, sNetCaseIgnoreList->clsString, NULL);
      for (i = 0; i < count; i++)
      {
         jstring value;

         NAlign32 (curPos);
         (*env)->SetObjectArrayElement (env, values, (jsize) i, (value = jncpGetString (env, curPos, limit)));
         (*env)->DeleteLocalRef (env, value);
      }
   }

   (*env)->SetObjectField (
                              env,
                              netCaseIgnoreList,
                              sNetCaseIgnoreList->ID.values,
                    (jobject) values);

   (*env)->DeleteLocalRef (env, values);

   return (netCaseIgnoreList);

} /* NetCaseIgnoreListCreate () */


/***** NetAttrRecordJNI.h *************************************************/

/*
 *   typedef struct
 *   {
 *      sturct_ci_list N_FAR *  next;
 *      pnstr8                  s;
 *   } CI_List_T;
 *
 *  CStruct:
 *    |pci_list (next) | pnstr | string | pci_list  | pnstr | string...
 *      |                  |______^        ^     |      |_______^
 *      | _________________________________|     |_____________ ...                  
 *
 * java array:
 *  | count |  string |  string  |  string | 
 */

/*
 *
 */
N_GLOBAL_FUNC_C (jbyteArray)
NetCaseIgnoreList_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
   jbyteArray byteArray;
   // NWNet variables
   pCI_List_T ciList;
   nuint8 *ciListPtr, *ptr;
   nuint32 count = 0;                        // initialize count

   if (cLength == 0) 
   {
      // allocate return byte[]
      byteArray = (*env)->NewByteArray (env, 4);

      return (byteArray);
   }

   // malloc temporary buffer
   ciListPtr = (nuint8 *) sysMalloc (cLength);

   ptr = ciListPtr + sizeof (nuint32);       // skip count
   
   // build the temporary buffer   
   for (ciList = (pCI_List_T) cValue; ciList; ciList = ciList->next)
   {
      unicpy ((unicode *) ptr, (unicode *) ciList->s);
      ptr += (unilen ((unicode *) ptr) + 1) * sizeof (unicode);

      count++;                               // increment count
   }
   
   *(pnuint32) ciListPtr = count;            // assign count

   // allocate return byte[]
   byteArray = (*env)->NewByteArray (env, cLength);

   // copy temporary buffer to byte[]
   (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) ciListPtr);

   // free temporary buffer
   sysFree (ciListPtr);

   return (byteArray);

} /* toByteArray () */


/*
 *
 */
N_GLOBAL_FUNC_C (nptr) 
NetCaseIgnoreList_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  values
)
{
   // JNI variables
   jbyte *byteArray, *ptr;
   jsize length;
   // NWNet variables
   pCI_List_T ciList, ciListPtr;
   nuint8 *dataPtr;
   nuint32 count;

   // get byte[]
   byteArray = ptr = (*env)->GetByteArrayElements (env, values, 0);

   // calculate NetMemory size
   count = *(pnuint32) ptr;
   
   // if do a modify with zero length of ci_list, we need the following lines
   // see line 174-180 also.
   //if (count == 0)
   //{
   //    // return buffer
   //    return((nptr) NULL);
   //}
   
   ptr += sizeof(nuint32);
   length = (*env)->GetArrayLength (env, values) + count * sizeof(CI_List_T);

   // malloc NetMemory buffer
   ciList = ciListPtr = (pCI_List_T) sysMalloc (length);
   dataPtr = (nuint8 *)(ciList) + sizeof(CI_List_T);

   // build the buffer
   while (count--)
   {
      unicpy ((unicode *)(ciListPtr->s = (pnchar) dataPtr), (unicode *) ptr);

      if (0 == count)
      {
         break;
      }
      length = (unilen ((unicode *) ptr) + 1) * sizeof (unicode);
      ptr += length;
      dataPtr += length;

      ciListPtr->next = (pCI_List_T) dataPtr;
      dataPtr +=  sizeof(CI_List_T);
      ciListPtr = ciListPtr->next;
   }
   ciListPtr->next = NULL;

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return((nptr) ciList);

} /* toCStruct () */


#ifdef __cplusplus
}
#endif


