/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include "jncpWire.h"

#include "NetIntegerJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetInteger
 *    extends NdsInteger
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected boolean value;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetInteger)
NetIntegerCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetInteger;
   jclass clsNetIntegerLR;
   //NJCL variables
   pNetInteger sNetInteger;

   clsNetIntegerLR = (*env)->FindClass (env, NETSYNTAXPKG "NetInteger");
   clsNetInteger = (*env)->NewGlobalRef (env, clsNetIntegerLR);
   (*env)->DeleteLocalRef (env, clsNetIntegerLR);

   sNetInteger = (pNetInteger) sysMalloc (sizeof (NetInteger));

   if (NULL != sNetInteger)
   {
      // assign jclass variables
      sNetInteger->cls = clsNetInteger;

      // assign jfieldID variables
      sNetInteger->ID.value = (*env)->GetFieldID (env, clsNetInteger, "value", "I");
   }
   return (sNetInteger);

} /* NetIntegerCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetIntegerCreate
(
   JNIEnv *env,
   pNetInteger sNetInteger,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netInteger = (*env)->AllocObject (env, sNetInteger->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      (*env)->SetIntField (
                              env,
                              netInteger,
                              sNetInteger->ID.value,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   return (netInteger);

} /* NetIntegerCreate () */


#ifdef __cplusplus
}
#endif


