/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include <unicode.h>

#include <nwalias.h>

#include "jncpWire.h"

#include "NetPathJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetPath
 *    extends NdsPath
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetPath)
NetPathCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetPath;
   jclass clsNetPathLR;
   //NJCL variables
   pNetPath sNetPath;

   clsNetPathLR = (*env)->FindClass (env, NETSYNTAXPKG "NetPath");
   clsNetPath = (*env)->NewGlobalRef (env, clsNetPathLR);
   (*env)->DeleteLocalRef (env, clsNetPathLR);

   sNetPath = (pNetPath) sysMalloc (sizeof (NetPath));

   if (NULL != sNetPath)
   {
      // assign jclass variables
      sNetPath->cls = clsNetPath;

      // assign jfieldID variables
      sNetPath->ID.nameSpaceType = (*env)->GetFieldID (env, clsNetPath, "nameSpaceType", "I");
      sNetPath->ID.volumeName = (*env)->GetFieldID (env, clsNetPath, "volumeName", "Ljava/lang/String;");
      sNetPath->ID.path = (*env)->GetFieldID (env, clsNetPath, "path", "Ljava/lang/String;");
   }
   return (sNetPath);

} /* NetPathCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetPathCreate
(
   JNIEnv *env,
   pNetPath sNetPath,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netPath = (*env)->AllocObject (env, sNetPath->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      (*env)->SetIntField (
                              env,
                              netPath,
                              sNetPath->ID.nameSpaceType,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   {
      jstring volumeName;

      (*env)->SetObjectField (
                                 env,
                                 netPath,
                                 sNetPath->ID.volumeName,
                        (jobject)(volumeName = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, volumeName);
   }

   {
      jstring path;

      NAlign32 (curPos);
      (*env)->SetObjectField (
                                 env,
                                 netPath,
                                 sNetPath->ID.path,
                        (jobject)(path = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, path);
   }

   return (netPath);

} /* NetPathCreate () */


/***** NetAttrRecordJNI.h *************************************************/

/*
 * typedef struct
 * {
 *    NWNAME_SPACE_TYPE   nameSpaceType;
 *    pnchar              volumeName;
 *    pnchar              path;
 * } Path_T;
 *
 * java array:
 *  | type | volumeName | path
 */

N_GLOBAL_FUNC_C (jbyteArray)
NetPath_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
   jbyteArray byteArray = NULL;
   // NWNet variables
   nuint8 *pathPtr;

   // malloc temporary buffer
   if (NULL != (pathPtr = (nuint8 *) sysMalloc (cLength)))
   {
      // NWNet variables
      pPath_T path;
      nuint8 *ptr;

      // NdsMemory.handle - ReplicaPointer C struct
      path = (pPath_T) cValue;

	  // advancing pointer
      ptr = pathPtr;

      // build the temporary buffer
      *(NWNAME_SPACE_TYPE *) ptr = path->nameSpaceType;
      ptr += sizeof (NWNAME_SPACE_TYPE);

      unicpy((unicode *) ptr, (unicode *) path->volumeName);
      ptr += (unilen ((unicode *) ptr) + 1) * sizeof (unicode);

      unicpy((unicode *) ptr, (unicode *) path->path);

      // allocate return byte[]
      byteArray = (*env)->NewByteArray (env, cLength);

      // copy temporary buffer to byte[]
      (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) pathPtr);

      // free temporary buffer
      sysFree (pathPtr);
   }

   return (byteArray);

} /* toByteArray () */


/*
 *
 */
N_GLOBAL_FUNC_C (nptr) 
NetPath_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  values
)
{
   // JNI variables
   jbyte *byteArray, *ptr;
   jsize length;
   // NWNet variables
   pPath_T path;
   nuint8 *dataPtr;

   // get byte[]
   byteArray = (*env)->GetByteArrayElements (env, values, 0);
   ptr = byteArray;

   // calculate NetMemory size
   length = (*env)->GetArrayLength (env, values) + sizeof(Path_T);

   // malloc NetMemory buffer
   path = (pPath_T) sysMalloc (length);
   dataPtr = (nuint8 *)(path) + sizeof(Path_T);

   // build the buffer
   path->nameSpaceType = *(NWNAME_SPACE_TYPE *) ptr;
   ptr += sizeof(NWNAME_SPACE_TYPE);

   unicpy ((unicode *)(path->volumeName = (pnchar) dataPtr), (unicode *) ptr);
   length = (unilen ((unicode *) ptr) + 1) * sizeof (unicode);
   ptr += length;
   dataPtr += length;

   unicpy ((unicode *)(path->path = (pnchar) dataPtr), (unicode *) ptr);

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) path);

} // toCStruct


#ifdef __cplusplus
}
#endif


